/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestion;
import java.util.List;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommandSuggestions.SuggestionsList.class})
abstract class SuggestionsListMixin {
    @Shadow
    private int lastNarratedEntry;
    @Shadow
    private int current;
    @Shadow
    @Final
    private List<Suggestion> suggestionList;

    SuggestionsListMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"getNarrationMessage()Lnet/minecraft/network/chat/Component;"}, cancellable=true)
    private void simplifySuggestionNarration(CallbackInfoReturnable<Component> cir) {
        this.lastNarratedEntry = this.current;
        String textNarration = this.getSuggestionTextNarration();
        cir.setReturnValue((Object)Component.nullToEmpty((String)textNarration));
        cir.cancel();
    }

    @Unique
    private String getSuggestionTextNarration() {
        Suggestion suggestion = this.suggestionList.get(this.current);
        Message message = suggestion.getTooltip();
        String format = Config.getInstance().commandSuggestionNarratorFormat;
        String textNarration = format.formatted(this.current + 1, this.suggestionList.size(), suggestion.getText());
        textNarration = message != null ? I18n.get((String)"minecraft_access.other.selected", (Object[])new Object[]{textNarration + " " + message.getString()}) : I18n.get((String)"minecraft_access.other.selected", (Object[])new Object[]{textNarration});
        return textNarration;
    }

    @Inject(at={@At(value="HEAD")}, method={"useSuggestion()V"})
    private void narrateCompletion(CallbackInfo ci) {
        String selected = this.suggestionList.get(this.current).getText();
        MainClass.narrate(selected, true);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/client/gui/components/CommandSuggestions;IIILjava/util/List;Z)V"})
    private void narrateFirstSuggestionWhenSuggestionsAreShown(CallbackInfo ci) {
        String first = this.getSuggestionTextNarration();
        MainClass.narrate(first, true);
    }
}

