/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.input.KeyEvent;
import org.apache.logging.log4j.util.Strings;
import org.mcaccess.minecraftaccess.MainClass;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextFieldHelper.class})
abstract class TextFieldHelperMixin {
    @Final
    @Shadow
    private Supplier<String> getMessageFn;
    @Shadow
    private int cursorPos;
    @Shadow
    private int selectionPos;

    TextFieldHelperMixin() {
    }

    @Shadow
    protected abstract String getSelected(String var1);

    @Inject(at={@At(value="TAIL")}, method={"setCursorToEnd()V"})
    private void narrateTextOfSwitchedLine(CallbackInfo ci) {
        MainClass.narrate(this.getMessageFn.get(), true);
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"})
    private void narrateCursorHoverOverText(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (Minecraft.getInstance().hasShiftDown()) {
            return;
        }
        switch (event.key()) {
            case 263: {
                if (Minecraft.getInstance().hasControlDown()) {
                    String hoveredText = this.getCursorHoveredOverText(this.getCursorPosByWordsWithOffset(-1));
                    MainClass.narrate(hoveredText, true);
                    break;
                }
                String hoveredText = this.getCursorHoveredOverText(this.getCursorPosWithOffset(-1));
                MainClass.narrate(hoveredText, true);
                break;
            }
            case 262: {
                if (Minecraft.getInstance().hasControlDown()) {
                    String hoveredText = this.getCursorHoveredOverText(this.getCursorPosByWordsWithOffset(1));
                    MainClass.narrate(hoveredText, true);
                    break;
                }
                String hoveredText = this.getCursorHoveredOverText(this.getCursorPosWithOffset(1));
                MainClass.narrate(hoveredText, true);
                break;
            }
            case 268: {
                String text = this.getMessageFn.get();
                if (!Strings.isNotEmpty((CharSequence)text)) break;
                MainClass.narrate(text.substring(0, 1), true);
                break;
            }
            case 269: {
                String text = this.getMessageFn.get();
                if (!Strings.isNotEmpty((CharSequence)text)) break;
                MainClass.narrate(text.substring(text.length() - 1), true);
            }
        }
    }

    @Unique
    private int getCursorPosByWordsWithOffset(int offset) {
        return StringSplitter.getWordPosition((String)this.getMessageFn.get(), (int)offset, (int)this.cursorPos, (boolean)true);
    }

    @Unique
    private int getCursorPosWithOffset(int offset) {
        return Util.offsetByCodepoints((String)this.getMessageFn.get(), (int)this.cursorPos, (int)offset);
    }

    @Inject(at={@At(value="RETURN")}, method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"})
    private void narrateSelectedText(CallbackInfoReturnable<Boolean> cir) {
        String selectedText = this.getSelected(this.getMessageFn.get());
        MainClass.narrate(selectedText, true);
    }

    @Inject(at={@At(value="HEAD")}, method={"removeCharsFromCursor(I)V"})
    private void narrateErasedText(int offset, CallbackInfo ci) {
        boolean allTextSelected;
        int cursorPos = Util.offsetByCodepoints((String)this.getMessageFn.get(), (int)this.cursorPos, (int)offset);
        boolean bl = allTextSelected = this.selectionPos == 0;
        if (!allTextSelected) {
            String erasedText = this.getCursorHoveredOverText(cursorPos);
            MainClass.narrate(erasedText, true);
        }
    }

    @Unique
    private String getCursorHoveredOverText(int changedCursorPos) {
        int endPos;
        int currentCursorPos = this.cursorPos;
        int startPos = Math.min(changedCursorPos, currentCursorPos);
        return startPos == (endPos = Math.max(changedCursorPos, currentCursorPos)) ? "" : this.getMessageFn.get().substring(startPos, endPos);
    }
}

