/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.resources.language.I18n;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.mixin.AdvancementToastAccessor;
import org.mcaccess.minecraftaccess.mixin.SystemToastAccessor;
import org.mcaccess.minecraftaccess.mixin.TutorialToastAccessor;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ToastManager.class})
abstract class ToastManagerMixin {
    ToastManagerMixin() {
    }

    @Inject(at={@At(value="TAIL")}, method={"addToast(Lnet/minecraft/client/gui/components/toasts/Toast;)V"})
    private void narrateToast(Toast toast, CallbackInfo ci) {
        StringBuilder toastTextBuilder = new StringBuilder();
        toastTextBuilder.append(I18n.get((String)"minecraft_access.toast.shown", (Object[])new Object[0])).append(I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0]));
        Toast toast2 = toast;
        Objects.requireNonNull(toast2);
        Toast toast3 = toast2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdvancementToast.class, RecipeToast.class, SystemToast.class, TutorialToast.class}, (Object)toast3, n)) {
            case 0: {
                AdvancementToast advancementToast = (AdvancementToast)toast3;
                ((AdvancementToastAccessor)advancementToast).getAdvancement().value().display().ifPresent(display -> toastTextBuilder.append(display.getType().getDisplayName().getString()).append(' ').append(display.getTitle().getString()));
                break;
            }
            case 1: {
                RecipeToast ignored = (RecipeToast)toast3;
                toastTextBuilder.append(I18n.get((String)"recipe.toast.title", (Object[])new Object[0])).append(". ").append(I18n.get((String)"recipe.toast.description", (Object[])new Object[0]));
                break;
            }
            case 2: {
                SystemToast systemToast = (SystemToast)toast3;
                toastTextBuilder.append(((SystemToastAccessor)systemToast).getTitle().getString()).append(". ").append(((SystemToastAccessor)systemToast).getMessageLines().stream().map(NarrationUtils::formattedCharSequenceToString).collect(Collectors.joining(" ")));
                break;
            }
            case 3: {
                TutorialToast tutorialToast = (TutorialToast)toast3;
                toastTextBuilder.append(((TutorialToastAccessor)tutorialToast).getLines().stream().map(NarrationUtils::formattedCharSequenceToString).collect(Collectors.joining(" ")));
                break;
            }
            default: {
                toastTextBuilder.append(I18n.get((String)"minecraft_access.toast.unknown", (Object[])new Object[0]));
            }
        }
        MainClass.narrate(toastTextBuilder.toString(), false);
    }
}

