/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.screen_reader;

import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderLinux;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderMacOS;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderWindows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScreenReaderController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenReaderController.class);

    private ScreenReaderController() {
    }

    @Nullable
    public static ScreenReaderInterface getAvailable() {
        switch (Util.getPlatform()) {
            case WINDOWS: {
                ScreenReaderWindows screenReaderWindows = new ScreenReaderWindows();
                screenReaderWindows.initializeScreenReader();
                return screenReaderWindows;
            }
            case OSX: {
                ScreenReaderMacOS screenReaderMacOS = new ScreenReaderMacOS();
                screenReaderMacOS.initializeScreenReader();
                return screenReaderMacOS;
            }
            case LINUX: {
                ScreenReaderLinux screenReaderLinux = new ScreenReaderLinux();
                screenReaderLinux.initializeScreenReader();
                return screenReaderLinux;
            }
        }
        log.error("No valid ScreenReader interface found");
        return null;
    }

    public static void refreshScreenReader() {
        ScreenReaderController.refreshScreenReader(false);
    }

    public static void refreshScreenReader(boolean closeOpenedScreen) {
        log.info("Refreshing screen reader");
        MainClass.setScreenReader(ScreenReaderController.getAvailable());
        if (!closeOpenedScreen) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        Minecraft.getInstance().player.clientSideCloseContainer();
        MainClass.narrate(I18n.get((String)"minecraft_access.access_menu.screen_reader_refreshed", (Object[])new Object[0]), true);
    }
}

