/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.screen_reader;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenReaderLinux
implements ScreenReaderInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenReaderLinux.class);
    private LibSpeechdWrapperInterface mainInstance = null;

    @Override
    public void initializeScreenReader() {
        Path path = Paths.get("libspeechdwrapper.so", new String[0]).toAbsolutePath();
        if (!Files.exists(path, new LinkOption[0])) {
            log.error("libspeechdwrapper not installed!");
            return;
        }
        log.info("Initializing libspeechdwrapper for linux at: {}", (Object)path);
        LibSpeechdWrapperInterface instance = (LibSpeechdWrapperInterface)Native.load((String)path.toString(), LibSpeechdWrapperInterface.class);
        int re = instance.Initialize();
        if (re == -1) {
            try {
                log.error("Unable to initialize screen reader, trying again in 3 seconds.");
                TimeUnit.SECONDS.sleep(3L);
                re = instance.Initialize();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (re == 1) {
            this.mainInstance = instance;
            log.info("Successfully initialized screen reader");
        } else {
            log.error("Unable to initialize screen reader");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.mainInstance != null;
    }

    @Override
    public void narrate(String text, boolean interrupt) {
        if (this.mainInstance == null) {
            return;
        }
        String narration = this.formatNarration(text);
        LibSpeechdWrapperInterface.GoString.ByValue str = new LibSpeechdWrapperInterface.GoString.ByValue();
        str.p = narration;
        str.n = narration.length();
        int re = this.mainInstance.Speak(str, interrupt);
        if (re == 1) {
            log.info("Narrating(interrupt:{})= {}", (Object)interrupt, (Object)narration);
        } else {
            log.error("Unable to narrate");
        }
    }

    @Override
    public void closeScreenReader() {
        if (this.mainInstance == null) {
            return;
        }
        int re = this.mainInstance.Close();
        if (re == 1) {
            log.info("Successfully closed screen reader");
        } else {
            log.error("Unable to close screen reader");
        }
    }

    private static interface LibSpeechdWrapperInterface
    extends Library {
        public int Initialize();

        public int Speak(GoString.ByValue var1, boolean var2);

        public int Close();

        public static class GoString
        extends Structure {
            public String p;
            public long n;

            protected List<String> getFieldOrder() {
                return Arrays.asList("p", "n");
            }

            public static class ByValue
            extends GoString
            implements Structure.ByValue {
            }
        }
    }
}

