/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils;

import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.ListBackedContainer;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.mixin.BaseSpawnerAccessor;
import org.mcaccess.minecraftaccess.mixin.WolfAccessor;
import org.mcaccess.minecraftaccess.utils.position.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NarrationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NarrationUtils.class);
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static final Map<IntegerProperty, Integer> CROP_AGE_PROPERTIES = Map.of(BlockStateProperties.AGE_1, 1, BlockStateProperties.AGE_2, 2, BlockStateProperties.AGE_3, 3, BlockStateProperties.AGE_4, 4, BlockStateProperties.AGE_5, 5, BlockStateProperties.AGE_7, 7, BlockStateProperties.AGE_15, 15, BlockStateProperties.AGE_25, 25);

    private NarrationUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static String narrateEntity(Entity entity) {
        nameOrType = entity.getName().getString();
        entityIsSitting = false;
        v0 = type = entity.hasCustomName() != false ? I18n.get((String)entity.getType().getDescriptionId(), (Object[])new Object[0]) : nameOrType;
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).onGround()) ** GOTO lbl-1000
        if (entity instanceof AbstractArrow) {
            abstractArrow = (AbstractArrow)entity;
            ** if (abstractArrow.pickup != AbstractArrow.Pickup.ALLOWED) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = true;
            ** GOTO lbl12
        }
lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
lbl12:
        // 2 sources

        isDroppedItem = v1;
        variant = NarrationUtils.getVariantInfo(entity);
        if (!Strings.isBlank((String)variant)) {
            map = Map.of("variant", variant, "animal", type);
            type = I18n.get((String)"minecraft_access.other.animal_variant_format", (Object[])new Object[]{map});
        }
        text = entity.hasCustomName() != false ? type + " " + nameOrType : type;
        equipments = new ArrayList<String>();
        if (Config.getInstance().narrateCrosshair.narrateAdditionalEntityPoses) {
            switch (1.$SwitchMap$net$minecraft$world$entity$Pose[entity.getPose().ordinal()]) {
                case 1: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.sleeping", (Object[])new Object[]{text});
                    break;
                }
                case 2: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.dying", (Object[])new Object[]{text});
                    break;
                }
                case 3: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.digging", (Object[])new Object[]{text});
                    break;
                }
                case 4: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.fall_flying", (Object[])new Object[]{text});
                    break;
                }
                case 5: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.roaring", (Object[])new Object[]{text});
                    break;
                }
                case 6: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.sliding", (Object[])new Object[]{text});
                    break;
                }
                case 7: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.swimming", (Object[])new Object[]{text});
                    break;
                }
                case 8: {
                    entityIsSitting = true;
                    break;
                }
                case 9: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.croaking", (Object[])new Object[]{text});
                    break;
                }
                case 10: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.emerging", (Object[])new Object[]{text});
                    break;
                }
                case 11: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.shooting", (Object[])new Object[]{text});
                    break;
                }
                case 12: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.inhaling", (Object[])new Object[]{text});
                    break;
                }
                case 13: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.sniffing", (Object[])new Object[]{text});
                    break;
                }
                case 14: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.crouching", (Object[])new Object[]{text});
                    break;
                }
                case 15: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.long_jumping", (Object[])new Object[]{text});
                    break;
                }
                case 16: {
                    text = I18n.get((String)"minecraft_access.read_crosshair.using_tongue", (Object[])new Object[]{text});
                    break;
                }
                case 17: {
                    break;
                }
                default: {
                    NarrationUtils.log.warn("Unhandled pose found: {} for additional pose narration in Narration Utils", (Object)entity.getPose().name());
                }
            }
        }
        if (!entityIsSitting) {
            v2 = entity;
            Objects.requireNonNull(v2);
            var8_8 = v2;
            var9_9 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Fox.class, Panda.class, Camel.class, TamableAnimal.class}, (Object)var8_8, var9_9)) {
                case 0: {
                    fox = (Fox)var8_8;
                    entityIsSitting = fox.isSitting();
                    break;
                }
                case 1: {
                    panda = (Panda)var8_8;
                    entityIsSitting = panda.isSitting();
                    break;
                }
                case 2: {
                    camel = (Camel)var8_8;
                    entityIsSitting = camel.isCamelSitting();
                    break;
                }
                case 3: {
                    tamableAnimal = (TamableAnimal)var8_8;
                    entityIsSitting = tamableAnimal.isInSittingPose();
                    break;
                }
            }
        }
        if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame()) {
            text = I18n.get((String)"minecraft_access.read_crosshair.tamed", (Object[])new Object[]{text});
        }
        if (entityIsSitting) {
            text = I18n.get((String)"minecraft_access.read_crosshair.sitting", (Object[])new Object[]{text});
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isBaby()) {
            text = I18n.get((String)"minecraft_access.read_crosshair.baby", (Object[])new Object[]{text});
        }
        if (entity instanceof Leashable && (leashable = (Leashable)entity).isLeashed()) {
            text = I18n.get((String)"minecraft_access.read_crosshair.leashed", (Object[])new Object[]{text});
        }
        v3 = entity;
        Objects.requireNonNull(v3);
        leashable = v3;
        var9_9 = 0;
        block33: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Sheep.class, ZombieVillager.class, Display.ItemDisplay.class, Display.TextDisplay.class, Display.BlockDisplay.class, ItemFrame.class}, (Object)leashable, var9_9)) {
                case 0: {
                    sheep = (Sheep)leashable;
                    v4 = NarrationUtils.getSheepInfo(sheep, text);
                    break block33;
                }
                case 1: {
                    zombieVillager = (ZombieVillager)leashable;
                    if (!zombieVillager.isConverting()) {
                        var9_9 = 2;
                        continue block33;
                    }
                    v4 = I18n.get((String)"minecraft_access.read_crosshair.zombie_villager_is_curing", (Object[])new Object[]{text});
                    break block33;
                }
                case 2: {
                    itemDisplay = (Display.ItemDisplay)leashable;
                    if (itemDisplay.itemRenderState() == null) {
                        var9_9 = 3;
                        continue block33;
                    }
                    itemName = itemDisplay.itemRenderState().itemStack().getItemName().getString();
                    v4 = I18n.get((String)"minecraft_access.point_of_interest.locking.display_item", (Object[])new Object[]{itemName});
                    break block33;
                }
                case 3: {
                    textDisplay = (Display.TextDisplay)leashable;
                    if (textDisplay.textRenderState() == null) {
                        var9_9 = 4;
                        continue block33;
                    }
                    v4 = textDisplay.textRenderState().text().getString();
                    break block33;
                }
                case 4: {
                    blockDisplay = (Display.BlockDisplay)leashable;
                    if (blockDisplay.blockRenderState() == null) {
                        var9_9 = 5;
                        continue block33;
                    }
                    ghostBlock = blockDisplay.blockRenderState().blockState().getBlock();
                    v4 = I18n.get((String)"minecraft_access.point_of_interest.locking.display_block", (Object[])new Object[]{ghostBlock.getName().getString()});
                    break block33;
                }
                case 5: {
                    frame = (ItemFrame)leashable;
                    item = frame.getItem();
                    if (!item.isEmpty()) {
                        itemName = item.getItemName().getString();
                        v4 = I18n.get((String)"minecraft_access.other.entity_with_equipments", (Object[])new Object[]{Map.of("entity", text, "equipments", itemName)});
                        break block33;
                    }
                    v4 = text;
                    break block33;
                }
                default: {
                    if (isDroppedItem) {
                        v4 = I18n.get((String)"minecraft_access.point_of_interest.locking.dropped_item", (Object[])new Object[]{text});
                        break block33;
                    }
                    v4 = text;
                    break block33;
                }
            }
            break;
        }
        text = v4;
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                equipment = livingEntity.getItemBySlot(slot);
                if (equipment.isEmpty()) continue;
                equipmentName = equipment.getHoverName().getString();
                equipments.add(equipmentName);
            }
        }
        if (!equipments.isEmpty()) {
            wordConnection = I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0]);
            values = Map.of("entity", text, "equipments", String.join((CharSequence)wordConnection, equipments));
            text = I18n.get((String)"minecraft_access.other.entity_with_equipments", (Object[])new Object[]{values});
        }
        return text;
    }

    private static String getVariantInfo(Entity animal) {
        Entity entity = animal;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Cat.class, Wolf.class, Axolotl.class}, (Object)entity2, n)) {
            case 0 -> {
                Cat cat = (Cat)entity2;
                yield I18n.get((String)String.format("minecraft_access.cat_variant.%s", cat.getVariant().unwrapKey().map(ResourceKey::location).map(ResourceLocation::toShortLanguageKey).orElse("other")), (Object[])new Object[0]);
            }
            case 1 -> {
                Wolf wolf = (Wolf)entity2;
                yield I18n.get((String)String.format("minecraft_access.wolf_variant.%s", ((WolfAccessor)wolf).callGetVariant().unwrapKey().map(ResourceKey::location).map(ResourceLocation::toShortLanguageKey).orElse("other")), (Object[])new Object[0]);
            }
            case 2 -> {
                Axolotl axolotl = (Axolotl)entity2;
                yield I18n.get((String)String.format("minecraft_access.axolotl_variant.%s", axolotl.getVariant().getName()), (Object[])new Object[0]);
            }
            default -> "";
        };
    }

    private static String getSheepInfo(Sheep sheep, String currentQuery) {
        String color = I18n.get((String)("color.minecraft." + sheep.getColor().getName()), (Object[])new Object[0]);
        String shearable = I18n.get((String)(sheep.readyForShearing() ? "minecraft_access.read_crosshair.shearable" : "minecraft_access.read_crosshair.not_shearable"), (Object[])new Object[]{currentQuery});
        return color + " " + shearable;
    }

    public static String narrateNumber(double num) {
        DecimalFormat df = new DecimalFormat();
        return (num = (double)Math.round(num * 10.0) / 10.0) >= 0.0 ? String.valueOf(df.format(num)) : I18n.get((String)"minecraft_access.other.negative", (Object[])new Object[]{df.format(-num)});
    }

    public static String narrateNumber(int num) {
        return num >= 0 ? String.valueOf(num) : I18n.get((String)"minecraft_access.other.negative", (Object[])new Object[]{-num});
    }

    public static String narrateRelativePositionOfPlayerAnd(BlockPos blockPos) {
        if (NarrationUtils.CLIENT.player == null) {
            return "up";
        }
        Direction dir = NarrationUtils.CLIENT.player.getDirection();
        Vec3 diff = new Vec3(NarrationUtils.CLIENT.player.getX(), NarrationUtils.CLIENT.player.getEyeY(), NarrationUtils.CLIENT.player.getZ()).subtract(Vec3.atCenterOf((Vec3i)blockPos));
        BlockPos diffBlockPos = new BlockPos((int)diff.x, (int)diff.y, (int)diff.z);
        String diffXBlockPos = "";
        String diffYBlockPos = "";
        String diffZBlockPos = "";
        if (diffBlockPos.getX() != 0) {
            if (dir == Direction.NORTH) {
                diffXBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getX(), "right", "left");
            } else if (dir == Direction.SOUTH) {
                diffXBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getX(), "left", "right");
            } else if (dir == Direction.EAST) {
                diffXBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getX(), "away", "behind");
            } else if (dir == Direction.WEST) {
                diffXBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getX(), "behind", "away");
            }
        }
        if (diffBlockPos.getY() != 0) {
            diffYBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getY(), "up", "down");
        }
        if (diffBlockPos.getZ() != 0) {
            if (dir == Direction.SOUTH) {
                diffZBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getZ(), "away", "behind");
            } else if (dir == Direction.NORTH) {
                diffZBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getZ(), "behind", "away");
            } else if (dir == Direction.EAST) {
                diffZBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getZ(), "right", "left");
            } else if (dir == Direction.WEST) {
                diffZBlockPos = NarrationUtils.getDifferenceString(diffBlockPos.getZ(), "left", "right");
            }
        }
        String text = dir == Direction.NORTH || dir == Direction.SOUTH ? String.format("%s  %s  %s", diffZBlockPos, diffYBlockPos, diffXBlockPos) : String.format("%s  %s  %s", diffXBlockPos, diffYBlockPos, diffZBlockPos);
        return text;
    }

    public static String getDifferenceString(int blocks, String key1, String key2) {
        return I18n.get((String)("minecraft_access.util.position_difference_" + (blocks < 0 ? key1 : key2)), (Object[])new Object[]{Math.abs(blocks)});
    }

    public static String narrateCoordinatesOf(BlockPos blockPos) {
        String posX = NarrationUtils.narrateNumber(blockPos.getX());
        String posY = NarrationUtils.narrateNumber(blockPos.getY());
        String posZ = NarrationUtils.narrateNumber(blockPos.getZ());
        return String.format("%s x %s y %s z", posX, posY, posZ);
    }

    public static Tuple<String, String> narrateBlockForContentChecking(BlockPos blockPos, String side) {
        ClientLevel clientWorld = NarrationUtils.CLIENT.level;
        if (clientWorld == null) {
            return new Tuple((Object)"", (Object)"");
        }
        BlockState blockState = clientWorld.getBlockState(blockPos);
        Block block = blockState.getBlock();
        BlockEntity blockEntity = clientWorld.getBlockEntity(blockPos);
        String name = block.getName().getString();
        Object narration = Strings.isBlank((String)side) ? name : name + " " + side;
        Object currentQuery = name + side;
        if (blockState.is(Blocks.WATER) || blockState.is(Blocks.LAVA)) {
            narration = NarrationUtils.narrateFluidBlock(blockPos);
            return new Tuple(narration, narration);
        }
        if (blockEntity != null) {
            if (blockState.is(BlockTags.ALL_SIGNS)) {
                narration = NarrationUtils.getSignInfo((SignBlockEntity)blockEntity, NarrationUtils.CLIENT.player, (String)narration);
            } else {
                BlockEntity blockEntity2 = blockEntity;
                Objects.requireNonNull(blockEntity2);
                BlockEntity blockEntity3 = blockEntity2;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BeehiveBlockEntity.class, SpawnerBlockEntity.class, CampfireBlockEntity.class, ListBackedContainer.class}, (Object)blockEntity3, n)) {
                    case 0: {
                        BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)blockEntity3;
                        Tuple<String, String> beehiveInfo = NarrationUtils.getBeehiveInfo(beehiveBlockEntity, blockState, (String)narration, (String)currentQuery);
                        narration = (String)beehiveInfo.getA();
                        currentQuery = (String)beehiveInfo.getB();
                        break;
                    }
                    case 1: {
                        SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity3;
                        Entity entity = ((BaseSpawnerAccessor)spawner.getSpawner()).getDisplayEntity();
                        String entityName = I18n.get((String)"minecraft_access.read_crosshair.spawner_empty", (Object[])new Object[0]);
                        if (entity != null) {
                            entityName = Objects.requireNonNull(entity.getDisplayName()).getString();
                        }
                        narration = entityName + " " + (String)narration;
                        currentQuery = entityName + (String)currentQuery;
                        break;
                    }
                    case 2: {
                        CampfireBlockEntity campfire = (CampfireBlockEntity)blockEntity3;
                        Tuple<String, String> result = NarrationUtils.getVisibleItems((List<ItemStack>)campfire.getItems(), (String)currentQuery, (String)narration);
                        currentQuery = (String)result.getA();
                        narration = (String)result.getB();
                        break;
                    }
                    case 3: {
                        ListBackedContainer listBacked = (ListBackedContainer)blockEntity3;
                        Tuple<String, String> result = NarrationUtils.getVisibleItems((List<ItemStack>)listBacked.getItems(), (String)currentQuery, (String)narration);
                        currentQuery = (String)result.getA();
                        narration = (String)result.getB();
                        break;
                    }
                }
            }
        }
        Tuple<String, String> cropsInfo = NarrationUtils.getCropsInfo(block, blockState, (String)narration, (String)currentQuery);
        narration = (String)cropsInfo.getA();
        currentQuery = (String)cropsInfo.getB();
        if (block instanceof FarmBlock && (Integer)blockState.getValue((Property)FarmBlock.MOISTURE) == 7) {
            narration = I18n.get((String)"minecraft_access.crop.wet_farmland", (Object[])new Object[]{narration});
            currentQuery = "wet" + (String)currentQuery;
        } else if (block instanceof EndPortalFrameBlock) {
            narration = (Boolean)blockState.getValue((Property)EndPortalFrameBlock.HAS_EYE) != false ? I18n.get((String)"minecraft_access.read_crosshair.end_portal_frame_with_eye", (Object[])new Object[]{narration}) : I18n.get((String)"minecraft_access.read_crosshair.end_portal_frame_empty", (Object[])new Object[]{narration});
        }
        Tuple<String, String> redstoneRelatedInfo = NarrationUtils.getRedstoneRelatedInfo(clientWorld, blockPos, block, blockState, (String)narration, (String)currentQuery);
        narration = (String)redstoneRelatedInfo.getA();
        currentQuery = (String)redstoneRelatedInfo.getB();
        if (clientWorld.getFluidState(blockPos).is((Fluid)Fluids.WATER)) {
            narration = I18n.get((String)"minecraft_access.crop.water_logged", (Object[])new Object[]{narration});
            currentQuery = "waterlogged" + (String)currentQuery;
        }
        return new Tuple(narration, currentQuery);
    }

    public static String narrateBlock(BlockPos pos, String side) {
        return (String)NarrationUtils.narrateBlockForContentChecking(pos, side).getA();
    }

    private static String getSignInfo(SignBlockEntity signEntity, LocalPlayer player, String narration) {
        CharSequence[] lines = new String[4];
        for (int i = 0; i < 4; ++i) {
            lines[i] = signEntity.getText(signEntity.isFacingFrontText((Player)player)).getMessage(i, false).getString();
        }
        String content = String.join((CharSequence)", ", lines);
        return I18n.get((String)("minecraft_access.read_crosshair.sign_" + (signEntity.isFacingFrontText((Player)player) ? "front" : "back") + "_content"), (Object[])new Object[]{narration, content});
    }

    private static Tuple<String, String> getVisibleItems(List<ItemStack> itemList, String currentQuery, String narration) {
        Object items = "";
        for (ItemStack item : itemList) {
            if (item.isEmpty()) continue;
            String itemName = item.getItemName().getString();
            items = (String)items + itemName + I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0]);
            currentQuery = (String)currentQuery + " " + itemName + " ";
        }
        if (!((String)items).isBlank()) {
            narration = I18n.get((String)"minecraft_access.other.entity_with_equipments", (Object[])new Object[]{Map.of("entity", narration, "equipments", items)});
        }
        return new Tuple(currentQuery, (Object)narration);
    }

    @NotNull
    private static Tuple<String, String> getRedstoneRelatedInfo(ClientLevel world, BlockPos blockPos, Block block, BlockState blockState, String narration, String currentQuery) {
        boolean isEmittingPower = world.hasSignal(blockPos, Direction.DOWN);
        boolean isReceivingPower = world.hasNeighborSignal(blockPos);
        Block block2 = block;
        Objects.requireNonNull(block2);
        Block block3 = block2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PistonBaseBlock.class, RedStoneWireBlock.class, HopperBlock.class, ObserverBlock.class, DispenserBlock.class, ComparatorBlock.class, RepeaterBlock.class}, (Object)block3, n)) {
            case 0: {
                PistonBaseBlock piston = (PistonBaseBlock)block3;
                String facing = ((Direction)blockState.getValue((Property)PistonBaseBlock.FACING)).getName();
                narration = I18n.get((String)"minecraft_access.read_crosshair.facing", (Object[])new Object[]{narration, I18n.get((String)("minecraft_access.direction." + facing), (Object[])new Object[0])});
                currentQuery = (String)currentQuery + "facing " + facing;
                if (!isReceivingPower) break;
                narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                currentQuery = (String)currentQuery + "powered";
                break;
            }
            case 1: {
                RedStoneWireBlock wire = (RedStoneWireBlock)block3;
                Tuple<String, String> p = NarrationUtils.getRedstoneWireInfo(blockState, blockPos, narration, (String)currentQuery);
                narration = (String)p.getA();
                currentQuery = (String)p.getB();
                break;
            }
            case 2: {
                HopperBlock hopper = (HopperBlock)block3;
                String facing = ((Direction)blockState.getValue((Property)HopperBlock.FACING)).getName();
                narration = I18n.get((String)"minecraft_access.read_crosshair.facing", (Object[])new Object[]{narration, I18n.get((String)("minecraft_access.direction." + facing), (Object[])new Object[0])});
                currentQuery = (String)currentQuery + "facing " + facing;
                if (!isReceivingPower) break;
                narration = I18n.get((String)"minecraft_access.read_crosshair.locked", (Object[])new Object[]{narration});
                currentQuery = (String)currentQuery + "locked";
                break;
            }
            case 3: {
                ObserverBlock observer = (ObserverBlock)block3;
                String facing = ((Direction)blockState.getValue((Property)ObserverBlock.FACING)).getName();
                narration = I18n.get((String)"minecraft_access.read_crosshair.facing", (Object[])new Object[]{narration, I18n.get((String)("minecraft_access.direction." + facing), (Object[])new Object[0])});
                currentQuery = (String)currentQuery + "facing " + facing;
                if (!isEmittingPower) break;
                narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                currentQuery = (String)currentQuery + "powered";
                break;
            }
            case 4: {
                DispenserBlock dispenser = (DispenserBlock)block3;
                String facing = ((Direction)blockState.getValue((Property)DispenserBlock.FACING)).getName();
                narration = I18n.get((String)"minecraft_access.read_crosshair.facing", (Object[])new Object[]{narration, I18n.get((String)("minecraft_access.direction." + facing), (Object[])new Object[0])});
                currentQuery = (String)currentQuery + "facing " + facing;
                if (!isReceivingPower) break;
                narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                currentQuery = (String)currentQuery + "powered";
                break;
            }
            case 5: {
                ComparatorBlock comparator = (ComparatorBlock)block3;
                ComparatorMode mode = (ComparatorMode)blockState.getValue((Property)ComparatorBlock.MODE);
                Direction facing = (Direction)blockState.getValue((Property)ComparatorBlock.FACING);
                String correctFacing = I18n.get((String)("minecraft_access.direction." + Orientation.getOppositeDirectionKey(facing.getName()).toLowerCase()), (Object[])new Object[0]);
                narration = I18n.get((String)"minecraft_access.read_crosshair.comparator_info", (Object[])new Object[]{narration, correctFacing, mode});
                if (isReceivingPower) {
                    narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                    currentQuery = (String)currentQuery + "powered";
                }
                currentQuery = (String)currentQuery + "mode:" + String.valueOf(mode) + " facing:" + correctFacing;
                break;
            }
            case 6: {
                RepeaterBlock repeater = (RepeaterBlock)block3;
                boolean locked = (Boolean)blockState.getValue((Property)RepeaterBlock.LOCKED);
                int delay = (Integer)blockState.getValue((Property)RepeaterBlock.DELAY);
                Direction facing = (Direction)blockState.getValue((Property)RepeaterBlock.FACING);
                String correctFacing = I18n.get((String)("minecraft_access.direction." + Orientation.getOppositeDirectionKey(facing.getName()).toLowerCase()), (Object[])new Object[0]);
                narration = I18n.get((String)"minecraft_access.read_crosshair.repeater_info", (Object[])new Object[]{narration, correctFacing, delay});
                currentQuery = (String)currentQuery + "delay:" + delay + " facing:" + correctFacing;
                if (!locked) break;
                narration = I18n.get((String)"minecraft_access.read_crosshair.locked", (Object[])new Object[]{narration});
                currentQuery = (String)currentQuery + "locked";
                break;
            }
            default: {
                DoorBlock doorBlock;
                if ((block instanceof GlowLichenBlock || block instanceof RedstoneLampBlock) && (isReceivingPower || isEmittingPower)) {
                    narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                    currentQuery = (String)currentQuery + "powered";
                    break;
                }
                if ((block instanceof RedstoneTorchBlock || block instanceof LeverBlock || block instanceof ButtonBlock) && isEmittingPower) {
                    narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                    currentQuery = (String)currentQuery + "powered";
                    break;
                }
                if (block instanceof DoorBlock && (doorBlock = (DoorBlock)block).isOpen(blockState) || block instanceof FenceGateBlock && ((Boolean)blockState.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
                    narration = I18n.get((String)"minecraft_access.read_crosshair.opened", (Object[])new Object[]{narration});
                    currentQuery = (String)currentQuery + "open";
                    break;
                }
                if (!isReceivingPower) break;
                narration = I18n.get((String)"minecraft_access.read_crosshair.powered", (Object[])new Object[]{narration});
                currentQuery = (String)currentQuery + "powered";
            }
        }
        return new Tuple((Object)narration, currentQuery);
    }

    @NotNull
    private static Tuple<String, String> getRedstoneWireInfo(BlockState blockState, BlockPos pos, String narration, String currentQuery) {
        boolean result;
        List connectedDirections;
        int powerLevel = (Integer)blockState.getValue((Property)RedStoneWireBlock.POWER);
        if (powerLevel > 0) {
            narration = I18n.get((String)"minecraft_access.read_crosshair.redstone_wire_power", (Object[])new Object[]{narration, powerLevel});
            currentQuery = (String)currentQuery + "power level " + powerLevel;
        }
        if ((connectedDirections = Direction.Plane.HORIZONTAL.stream().map(direction -> {
            String directionName = I18n.get((String)("minecraft_access.direction." + direction.getName()), (Object[])new Object[0]);
            switch ((RedstoneSide)blockState.getValue((Property)RedStoneWireBlock.PROPERTY_BY_DIRECTION.get(direction))) {
                case UP: {
                    return directionName + " " + I18n.get((String)"minecraft_access.direction.up", (Object[])new Object[0]);
                }
                case SIDE: {
                    return directionName;
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList())).size() == 4 && !(result = BlockPos.betweenClosedStream((BlockPos)pos.offset(1, -1, 0), (BlockPos)pos.offset(1, 1, 0)).anyMatch(blockPos -> {
            assert (NarrationUtils.CLIENT.level != null);
            return NarrationUtils.CLIENT.level.getBlockState(blockPos).getBlock() instanceof RedStoneWireBlock;
        }))) {
            return new Tuple((Object)narration, currentQuery);
        }
        String directionsNarration = String.join((CharSequence)I18n.get((String)"minecraft_access.other.words_connection", (Object[])new Object[0]), connectedDirections);
        narration = I18n.get((String)"minecraft_access.read_crosshair.redstone_wire_connection", (Object[])new Object[]{narration, directionsNarration});
        currentQuery = (String)currentQuery + "connected to " + String.valueOf(connectedDirections);
        return new Tuple((Object)narration, currentQuery);
    }

    @NotNull
    private static Tuple<String, String> getBeehiveInfo(BeehiveBlockEntity blockEntity, BlockState blockState, String narration, String currentQuery) {
        boolean isSmoked = blockEntity.isSedated();
        int honeyLevel = (Integer)blockState.getValue((Property)BeehiveBlock.HONEY_LEVEL);
        Direction facingDirection = (Direction)blockState.getValue((Property)BeehiveBlock.FACING);
        if (isSmoked) {
            narration = I18n.get((String)"minecraft_access.read_crosshair.bee_hive_smoked", (Object[])new Object[]{narration});
            currentQuery = (String)currentQuery + "smoked";
        }
        if (honeyLevel > 0) {
            narration = I18n.get((String)"minecraft_access.read_crosshair.bee_hive_honey_level", (Object[])new Object[]{narration, honeyLevel});
            currentQuery = (String)currentQuery + "honey-level:" + honeyLevel;
        }
        narration = I18n.get((String)"minecraft_access.read_crosshair.bee_hive_facing", (Object[])new Object[]{narration, facingDirection.getName()});
        currentQuery = (String)currentQuery + "facing:" + facingDirection.getName();
        return new Tuple((Object)narration, currentQuery);
    }

    @NotNull
    private static Tuple<String, String> getCropsInfo(Block block, BlockState blockState, String narration, String currentQuery) {
        Optional<Map.Entry> ageProperty;
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return NarrationUtils.addCropGrowth(narration, currentQuery, crop.getAge(blockState), crop.getMaxAge());
        }
        if ((block instanceof BonemealableBlock || block instanceof VegetationBlock) && (ageProperty = CROP_AGE_PROPERTIES.entrySet().stream().filter(entry -> blockState.hasProperty((Property)entry.getKey())).findFirst()).isPresent()) {
            return NarrationUtils.addCropGrowth(narration, currentQuery, (Integer)blockState.getValue((Property)ageProperty.get().getKey()), (Integer)ageProperty.get().getValue());
        }
        return new Tuple((Object)narration, (Object)currentQuery);
    }

    @NotNull
    private static Tuple<String, String> addCropGrowth(String narration, String currentQuery, int age, int maxAge) {
        if (age == maxAge) {
            return new Tuple((Object)I18n.get((String)"minecraft_access.crop.mature", (Object[])new Object[]{narration}), (Object)I18n.get((String)"minecraft_access.crop.mature", (Object[])new Object[]{currentQuery}));
        }
        float growth = (float)age / (float)maxAge;
        return new Tuple((Object)I18n.get((String)"minecraft_access.crop.percent", (Object[])new Object[]{(int)(growth * 100.0f), narration}), (Object)I18n.get((String)"minecraft_access.crop.percent", (Object[])new Object[]{(int)(growth * 100.0f), currentQuery}));
    }

    private static String narrateFluidBlock(BlockPos pos) {
        assert (NarrationUtils.CLIENT.level != null);
        FluidState fluidState = NarrationUtils.CLIENT.level.getFluidState(pos);
        Optional<String> fluidName = NarrationUtils.getTranslatedName(fluidState.holder(), "block");
        int level = fluidState.getAmount();
        String levelString = level < 8 ? I18n.get((String)"minecraft_access.read_crosshair.fluid_level", (Object[])new Object[]{level}) : "";
        return fluidName.map(name -> String.format("%s %s", name, levelString)).orElse(levelString);
    }

    public static String narrateEffect(MobEffectInstance effect) {
        StringBuilder result = new StringBuilder();
        result.append(I18n.get((String)effect.getDescriptionId(), (Object[])new Object[0])).append(' ');
        int amplifier = effect.getAmplifier();
        if (amplifier > 1) {
            result.append(amplifier).append(' ');
        }
        if (effect.isInfiniteDuration()) {
            result.append(I18n.get((String)"effect.duration.infinite", (Object[])new Object[0]));
        } else {
            Duration d = Duration.ofSeconds(effect.getDuration() / 20);
            String fmt = d.toHoursPart() == 0 ? "mm':'ss" : "HH':'mm':'ss";
            result.append(DurationFormatUtils.formatDuration((long)d.toMillis(), (String)fmt));
        }
        return result.toString();
    }

    public static Optional<String> getTranslatedName(Holder<?> holder, String type) {
        Optional<String> translatedName = holder.unwrapKey().map(key -> I18n.get((String)key.location().toLanguageKey(type), (Object[])new Object[0]));
        if (translatedName.isEmpty()) {
            log.error("Failed to get a valid translation of the {} name", (Object)type);
        }
        return translatedName;
    }

    @Contract(pure=true)
    @NotNull
    public static String formattedCharSequenceToString(@NotNull FormattedCharSequence charSequence) {
        StringBuilder builder = new StringBuilder();
        charSequence.accept((index, style, codePoint) -> {
            builder.appendCodePoint(codePoint);
            return true;
        });
        return builder.toString();
    }
}

