/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class PlayerUtils {
    public static Vec3 currentEntityLookingAtPosition = null;
    private static final Minecraft CLIENT = Minecraft.getInstance();

    private PlayerUtils() {
    }

    public static void lookAt(Entity entity) {
        Vec3 firstPos;
        assert (PlayerUtils.CLIENT.player != null);
        Vec3 playerEyePos = PlayerUtils.CLIENT.player.getEyePosition();
        boolean targetIsEnderman = entity instanceof EnderMan;
        Vec3 vec3 = firstPos = targetIsEnderman ? entity.blockPosition().getCenter() : entity.getEyePosition();
        if (PlayerUtils.isVisibleToPlayer(playerEyePos, firstPos, entity)) {
            PlayerUtils.CLIENT.player.lookAt(EntityAnchorArgument.Anchor.EYES, firstPos);
            currentEntityLookingAtPosition = firstPos;
            return;
        }
        AABB box = entity.getBoundingBox();
        double stepX = 1.0 / ((box.maxX - box.minX) * 2.0 + 1.0);
        double stepY = 1.0 / ((box.maxY - box.minY) * 2.0 + 1.0);
        double stepZ = 1.0 / ((box.maxZ - box.minZ) * 2.0 + 1.0);
        double initX = (1.0 - Math.floor(1.0 / stepX) * stepX) / 2.0;
        double initZ = (1.0 - Math.floor(1.0 / stepZ) * stepZ) / 2.0;
        if (stepX < 0.0 || stepY < 0.0 || stepZ < 0.0) {
            PlayerUtils.CLIENT.player.lookAt(EntityAnchorArgument.Anchor.EYES, firstPos);
            currentEntityLookingAtPosition = firstPos;
            return;
        }
        double maxY = targetIsEnderman ? Mth.lerp((double)0.7, (double)box.minY, (double)box.maxY) / 2.0 : box.maxY;
        for (double i = 0.0; i <= 1.0; i += stepX) {
            for (double j = 0.0; j <= 1.0; j += stepY) {
                for (double k = 0.0; k <= 1.0; k += stepZ) {
                    double pz;
                    double py;
                    double px = Mth.lerp((double)i, (double)box.minX, (double)box.maxX);
                    Vec3 vec3d = new Vec3(px + initX, py = Mth.lerp((double)j, (double)box.minY, (double)maxY), (pz = Mth.lerp((double)k, (double)box.minZ, (double)box.maxZ)) + initZ);
                    if (!PlayerUtils.isVisibleToPlayer(playerEyePos, vec3d, entity)) continue;
                    PlayerUtils.CLIENT.player.lookAt(EntityAnchorArgument.Anchor.EYES, vec3d);
                    currentEntityLookingAtPosition = vec3d;
                    return;
                }
            }
        }
        PlayerUtils.CLIENT.player.lookAt(EntityAnchorArgument.Anchor.EYES, firstPos);
        currentEntityLookingAtPosition = firstPos;
    }

    public static boolean isVisibleToPlayer(Vec3 playerEyePos, Vec3 somewhereOnEntity, Entity entity) {
        BlockHitResult hitResult = entity.level().clip(new ClipContext(somewhereOnEntity, playerEyePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        return hitResult.getType() == HitResult.Type.MISS;
    }

    public static boolean isInFluid() {
        LocalPlayer player = PlayerUtils.CLIENT.player;
        assert (player != null);
        return player.isSwimming() || player.isUnderWater() || player.isInWater() || player.isInLava();
    }

    public static HitResult crosshairTarget(double rayCastDistance) {
        BlockHitResult fluidHitResult = PlayerUtils.crosshairFluidTarget(rayCastDistance);
        if (fluidHitResult.getType() == HitResult.Type.BLOCK && !PlayerUtils.isInFluid()) {
            return fluidHitResult;
        }
        return PlayerUtils.CLIENT.hitResult;
    }

    private static BlockHitResult crosshairFluidTarget(double rayCastDistance) {
        boolean thisBlockIsFluidBlock;
        Entity camera = Objects.requireNonNull(CLIENT.getCameraEntity());
        HitResult hit = camera.pick(rayCastDistance, 0.0f, true);
        BlockHitResult missed = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.UP, (BlockPos)BlockPos.ZERO);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return missed;
        }
        BlockPos blockPos = ((BlockHitResult)hit).getBlockPos();
        ClientLevel world = PlayerUtils.CLIENT.level;
        assert (world != null);
        BlockState blockState = world.getBlockState(blockPos);
        boolean bl = thisBlockIsFluidBlock = blockState.is(Blocks.WATER) || blockState.is(Blocks.LAVA);
        if (!thisBlockIsFluidBlock) {
            return missed;
        }
        FluidState fluidState = world.getFluidState(blockPos);
        if (fluidState.isEmpty()) {
            return missed;
        }
        return (BlockHitResult)hit;
    }
}

