/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.condition;

import org.mcaccess.minecraftaccess.Config;

public class Interval {
    public long lastRunTime;
    private long delay;

    protected Interval(long lastRunTime, long delayInNanoTime) {
        this.lastRunTime = lastRunTime;
        this.delay = delayInNanoTime;
    }

    public static Interval ms(long delay) {
        return new Interval(System.nanoTime(), Unit.MILLISECOND.toNano(delay));
    }

    public static Interval sec(long delay) {
        return new Interval(System.nanoTime(), Unit.SECOND.toNano(delay));
    }

    public static Interval defaultDelay() {
        return Interval.ms(Config.getInstance().multipleClickSpeedMilliseconds);
    }

    public void reset() {
        this.lastRunTime = System.nanoTime();
    }

    public boolean isReady() {
        if (this.delay == 0L) {
            return false;
        }
        if (System.nanoTime() - this.lastRunTime > this.delay) {
            this.reset();
            return true;
        }
        return false;
    }

    public void setDelay(long delay, Unit unit) {
        this.delay = unit.toNano(delay);
    }

    public void adjustNextReadyTimeBy(boolean anyFunctionTriggered) {
        if (anyFunctionTriggered) {
            this.reset();
        } else {
            this.beReady();
        }
    }

    public void beReady() {
        this.lastRunTime = 0L;
    }

    public static enum Unit {
        MILLISECOND(1000000L),
        SECOND(1000000000L);

        private final long factor;

        private Unit(long factor) {
            this.factor = factor;
        }

        public long toNano(long value) {
            return value * this.factor;
        }
    }
}

