/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.Contract;

public class Keystroke {
    protected static final List<Keystroke> INSTANCES = new ArrayList<Keystroke>();
    protected boolean hasKeyPressed = false;
    protected BooleanSupplier condition;
    protected final TriggeredAt timing;
    protected int triggeredCount;

    public Keystroke(KeyMapping singleKey) {
        this(() -> singleKey.isDown(), TriggeredAt.PRESSING);
    }

    public Keystroke(BooleanSupplier condition) {
        this(condition, TriggeredAt.PRESSING);
    }

    public Keystroke(BooleanSupplier condition, TriggeredAt timing) {
        this.condition = condition;
        this.timing = Optional.ofNullable(timing).orElse(TriggeredAt.PRESSING);
        this.triggeredCount = 0;
        INSTANCES.add(this);
    }

    public void updateStateForNextTick() {
        this.hasKeyPressed = this.isPressing();
        if (this.timing.happen(this)) {
            ++this.triggeredCount;
        }
        if (this.timing.aboutToHappen(this)) {
            this.triggeredCount = 0;
        }
    }

    public boolean isPressing() {
        return this.condition.getAsBoolean();
    }

    public boolean isNotPressing() {
        return !this.isPressing();
    }

    protected boolean hasPressedPreviousTick() {
        return this.hasKeyPressed;
    }

    public boolean isReleased() {
        return !this.isPressing() && this.hasPressedPreviousTick();
    }

    public boolean isPressed() {
        return this.isPressing() && !this.hasPressedPreviousTick();
    }

    @Contract(pure=true)
    public boolean canBeTriggered() {
        boolean correctKeystrokeState = this.timing.happen(this);
        return correctKeystrokeState && this.otherTriggerConditions();
    }

    protected boolean otherTriggerConditions() {
        return this.triggeredCount == 0;
    }

    public static void updateInstances() {
        INSTANCES.forEach(Keystroke::updateStateForNextTick);
    }

    public static enum TriggeredAt {
        PRESSING(Keystroke::isPressing, Keystroke::isNotPressing),
        NOT_PRESSING(Keystroke::isNotPressing, Keystroke::isPressing),
        PRESSED(Keystroke::isPressed, Keystroke::isNotPressing),
        RELEASED(Keystroke::isReleased, Keystroke::isPressing);

        private final Function<Keystroke, Boolean> triggerCondition;
        private final Function<Keystroke, Boolean> preCondition;

        private TriggeredAt(Function<Keystroke, Boolean> triggerCondition, Function<Keystroke, Boolean> preCondition) {
            this.triggerCondition = triggerCondition;
            this.preCondition = preCondition;
        }

        public boolean happen(Keystroke keystroke) {
            return this.triggerCondition.apply(keystroke);
        }

        public boolean aboutToHappen(Keystroke keystroke) {
            return this.preCondition.apply(keystroke);
        }
    }
}

