/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.condition;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Contract;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;

public class MenuKeystroke
extends Keystroke {
    boolean isMenuJustClosed = false;

    public MenuKeystroke(KeyMapping singleKey) {
        this(() -> singleKey.isDown());
    }

    public MenuKeystroke(BooleanSupplier condition) {
        super(condition);
    }

    @Contract(pure=true)
    public boolean canOpenMenu() {
        return this.isReleased() && !this.isMenuJustClosed;
    }

    public boolean closeMenuIfMenuKeyPressing() {
        if (this.isPressing()) {
            this.isMenuJustClosed = true;
            Objects.requireNonNull(Minecraft.getInstance().screen).onClose();
            return true;
        }
        return false;
    }

    @Override
    public void updateStateForNextTick() {
        if (this.isReleased()) {
            this.isMenuJustClosed = false;
        }
        super.updateStateForNextTick();
    }
}

