/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.position;

import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.position.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlayerPositionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerPositionUtils.class);
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static final String POSITION_FORMAT = "{x}, {y}, {z}";

    private PlayerPositionUtils() {
    }

    public static String getNarratableXYZPosition() {
        return POSITION_FORMAT.replace("{x}", PlayerPositionUtils.getNarratableXPos()).replace("{y}", PlayerPositionUtils.getNarratableYPos()).replace("{z}", PlayerPositionUtils.getNarratableZPos());
    }

    public static String getNarratableXPos() {
        assert (PlayerPositionUtils.CLIENT.player != null);
        return NarrationUtils.narrateNumber(PlayerPositionUtils.CLIENT.player.position().x) + "x";
    }

    public static String getNarratableYPos() {
        assert (PlayerPositionUtils.CLIENT.player != null);
        return NarrationUtils.narrateNumber(PlayerPositionUtils.CLIENT.player.position().y) + "y";
    }

    public static String getNarratableZPos() {
        assert (PlayerPositionUtils.CLIENT.player != null);
        return NarrationUtils.narrateNumber(PlayerPositionUtils.CLIENT.player.position().z) + "z";
    }

    public static int getVerticalFacingDirection() {
        assert (PlayerPositionUtils.CLIENT.player != null);
        return (int)PlayerPositionUtils.CLIENT.player.getRotationVector().x;
    }

    public static String getVerticalFacingDirectionInWords() {
        int angle = PlayerPositionUtils.getVerticalFacingDirection();
        if (PlayerPositionUtils.isBetween(angle, -90, -88)) {
            return I18n.get((String)"minecraft_access.direction.up", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, -87, -3)) {
            return I18n.get((String)"minecraft_access.direction.degrees", (Object[])new Object[]{NarrationUtils.narrateNumber(-angle)}) + " " + I18n.get((String)"minecraft_access.direction.up", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, -2, 2)) {
            return I18n.get((String)"minecraft_access.direction.straight", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, 3, 87)) {
            return I18n.get((String)"minecraft_access.direction.degrees", (Object[])new Object[]{NarrationUtils.narrateNumber(angle)}) + " " + I18n.get((String)"minecraft_access.direction.down", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, 88, 90)) {
            return I18n.get((String)"minecraft_access.direction.down", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x <= upper;
    }

    public static int getHorizontalFacingDirectionInDegrees() {
        assert (PlayerPositionUtils.CLIENT.player != null);
        int angle = (int)PlayerPositionUtils.CLIENT.player.getRotationVector().y;
        return angle % 360;
    }

    public static Orientation getHorizontalFacing() {
        int angle = PlayerPositionUtils.getHorizontalFacingDirectionInDegrees();
        return Orientation.ofHorizontal(angle);
    }

    public static String getHorizontalFacingDirectionInWords() {
        return I18n.get((String)("minecraft_access.direction." + String.valueOf((Object)PlayerPositionUtils.getHorizontalFacing())), (Object[])new Object[0]);
    }
}

