/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.ui;

import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtils {
    private NavigationUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDirectionBackward(FocusNavigationEvent event) {
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            ScreenDirection screenDirection;
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            ScreenDirection direction = screenDirection = arrowNavigation.direction();
            if (direction != ScreenDirection.UP) return false;
            return true;
        }
        if (!(event instanceof FocusNavigationEvent.TabNavigation)) return false;
        FocusNavigationEvent.TabNavigation tabNavigation = (FocusNavigationEvent.TabNavigation)event;
        try {
            boolean bl;
            boolean forward = bl = tabNavigation.forward();
            if (forward) return false;
            return true;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Nullable
    public static ComponentPath getFocusPathStartFrom(GuiEventListener root, FocusNavigationEvent event) {
        ComponentPath componentPath;
        if (root instanceof ContainerEventHandler) {
            ContainerEventHandler container = (ContainerEventHandler)root;
            componentPath = container.nextFocusPath(event);
        } else {
            componentPath = ComponentPath.leaf((GuiEventListener)root);
        }
        return componentPath;
    }

    public static void clearFocus(GuiEventListener component) {
        if (component instanceof ContainerEventHandler) {
            ContainerEventHandler container = (ContainerEventHandler)component;
            container.setFocused(null);
        } else {
            component.setFocused(false);
        }
    }
}

