/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="convenientcurioscontainer", bus=EventBusSubscriber.Bus.MOD)
public class ConvenientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static Set<Item> forbiddenTrinkets;
    private static Set<Item> allowedTrinkets;
    private static boolean enableDarkMode;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> FORBIDDEN_TRINKETS;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ALLOWED_TRINKETS;
    private static ModConfigSpec.BooleanValue DARK_MODE;
    static final ModConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        forbiddenTrinkets = ((List)FORBIDDEN_TRINKETS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        allowedTrinkets = ((List)ALLOWED_TRINKETS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        enableDarkMode = DARK_MODE.getAsBoolean();
    }

    public static Set<Item> getForbiddenTrinkets() {
        return forbiddenTrinkets;
    }

    public static Set<Item> getAllowedTrinkets() {
        return allowedTrinkets;
    }

    public static boolean getEnableDarkMode() {
        return enableDarkMode;
    }

    static {
        FORBIDDEN_TRINKETS = BUILDER.translation("config.forbidden_items").comment(new String[]{"Blacklisted Items - add the name of the item to blacklist, modid:item_name format, separated with comma.", "Example: \"curios:amulet\", \"curios:ring\"."}).defineListAllowEmpty("forbiddenTrinkets", Collections.emptyList(), () -> "", o -> o instanceof String);
        ALLOWED_TRINKETS = BUILDER.translation("config.allowed_items").comment(new String[]{"Whitelisted Items - add the name of the item to whitelist, modid:item_name format, separated with comma.", "Example: \"curios:amulet\", \"curios:ring\"."}).defineListAllowEmpty("allowedTrinkets", Collections.emptyList(), () -> "", o -> o instanceof String);
        DARK_MODE = BUILDER.translation("config.dark_mode").comment("Set to true to enable dark mode in the mod's GUI screen").define("enableDarkMode", false);
        SPEC = BUILDER.build();
    }
}

