/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.common;

import com.leobeliik.convenientcurioscontainer.items.ConvenientItem;
import com.leobeliik.convenientcurioscontainer.platform.Services;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;

public class ConvenientMenu
extends AbstractContainerMenu {
    private final Player player;
    private final ItemStack item;
    private SimpleContainer container = new SimpleContainer(54);
    private int currentPage = 1;
    private int maxPage = 1;
    public int curiosSize = 0;

    public ConvenientMenu(int id, Inventory inventory, ItemStack stack) {
        super(Services.PLATFORM.getMenu(), id);
        this.player = inventory.player;
        this.item = stack;
        this.loadItems();
        this.addSlots();
    }

    public void addSlots() {
        this.slots.clear();
        this.addContainerSlots();
        this.addPlayerInvSlots();
        this.addCuriosSlots();
        this.broadcastChanges();
    }

    private void addContainerSlots() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot(this, (Container)this.container, j + i * 9, j * 18 + 8, i * 18 + 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return Services.PLATFORM.mayPlaceItem(stack);
                    }
                });
            }
        }
    }

    private void addPlayerInvSlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.player.getInventory(), j + i * 9 + 9, j * 18 + 8, i * 18 + 140));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.player.getInventory(), i, i * 18 + 8, 198));
        }
    }

    private void addCuriosSlots() {
        List<Slot> slots = Services.PLATFORM.curiosContainer(this.player);
        int pageSize = 33;
        int startIndex = (this.currentPage - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, slots.size());
        this.maxPage = Math.ceilDiv(slots.size(), 33);
        this.curiosSize = slots.size();
        slots.subList(startIndex, endIndex).forEach(x$0 -> this.addSlot((Slot)x$0));
    }

    public void clicked(int slot, int mouseClick, @NotNull ClickType type, @NotNull Player player) {
        if (slot >= 54 && slot < 90 && this.getSlot(slot).hasItem() && this.getSlot(slot).getItem().getItem() instanceof ConvenientItem) {
            return;
        }
        if (mouseClick == 1 && slot >= 0 && slot < 54 && this.getSlot(slot).hasItem()) {
            if (type == ClickType.PICKUP) {
                this.swapCurios(this.getSlot(slot), player, false);
                return;
            }
            if (type == ClickType.QUICK_MOVE) {
                this.swapCurios(this.getSlot(slot), player, true);
                return;
            }
        }
        super.clicked(slot, mouseClick, type, player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStackOG = slot.getItem();
            itemStackCopy = itemStackOG.copy();
            int size = 54;
            int curioSlotSize = this.slots.size() - 90;
            if (index < size ? !this.moveItemStackTo(itemStackOG, size, this.slots.size() - curioSlotSize, true) : !this.moveItemStackTo(itemStackOG, 0, size, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStackOG.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStackCopy;
    }

    private void swapCurios(Slot slot, Player player, boolean secondSlot) {
        ItemStack curiosItem = null;
        ItemStack containerItem = slot.getItem();
        Slot curioSlot = null;
        for (Slot cs : this.slots) {
            if (!Services.PLATFORM.isCurioSlot(cs) || !cs.mayPlace(containerItem)) continue;
            if (secondSlot) {
                secondSlot = false;
                continue;
            }
            curiosItem = cs.getItem();
            curioSlot = cs;
            break;
        }
        if (curiosItem == null) {
            return;
        }
        if (!curiosItem.isEmpty() || !containerItem.isEmpty()) {
            if (curiosItem.isEmpty()) {
                if (slot.mayPickup(player)) {
                    curioSlot.set(containerItem);
                    slot.set(ItemStack.EMPTY);
                    slot.onTake(player, containerItem);
                }
            } else if (slot.mayPickup(player) && slot.mayPlace(curiosItem) && curioSlot.mayPickup(player)) {
                int l1 = slot.getMaxStackSize(curiosItem);
                if (curiosItem.getCount() > l1) {
                    slot.set(curiosItem.split(l1));
                    slot.onTake(player, containerItem);
                    if (!curioSlot.mayPlace(containerItem)) {
                        player.drop(containerItem, true);
                    }
                } else {
                    slot.set(curiosItem);
                    curioSlot.set(containerItem);
                    slot.onTake(player, containerItem);
                }
            }
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    private void loadItems() {
        ItemContainerContents component = (ItemContainerContents)this.item.get(DataComponents.CONTAINER);
        if (component != null) {
            List items = component.stream().toList();
            for (int i = 0; i < items.size() && i < 54; ++i) {
                this.container.setItem(i, (ItemStack)items.get(i));
            }
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.item.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.container.getItems()));
        this.item.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void ChangePage(boolean b) {
        this.slots.clear();
        if (this.player.level().isClientSide()) {
            Services.PLATFORM.pageChange(b);
        }
        if (b && this.currentPage < this.maxPage) {
            ++this.currentPage;
        }
        if (!b && this.currentPage > 1) {
            --this.currentPage;
        }
        this.addSlots();
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }
}

