/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.helpfulcampfires.mixin;

import com.khazoda.helpfulcampfires.HelpfulCampfiresMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class CampfireBlockEntityMixin {
    @Unique
    private static final int EFFECT_RADIUS = 4;
    @Unique
    private static final int EFFECT_REMOVAL_RADIUS = 9;
    @Unique
    private static final int GRACE_PERIOD_TICKS = 10;
    @Unique
    private static final int MIN_SHORT_AMBIENT_DELAY = 500;
    @Unique
    private static final int MAX_EXTRA_AMBIENT_DELAY = 100;
    @Unique
    private static final int INITIAL_SOUND_DELAY = 100;
    @Unique
    private static final int EFFECT_RADIUS_SQ = 16;
    @Unique
    private static final int EFFECT_REMOVAL_RADIUS_SQ = 81;
    @Unique
    private static long helpfulcampfires$lastGlobalHearingCheck = 0L;
    @Unique
    private boolean helpfulcampfires$wasActive = false;
    @Unique
    private long helpfulcampfires$lastStatusChange = 0L;
    @Unique
    private long helpfulcampfires$nextAmbientSound = 0L;
    @Unique
    private long helpfulcampfires$firstLitTime = 0L;
    @Unique
    private long helpfulcampfires$nextAmbientFire = 0L;
    @Unique
    private Holder<MobEffect> helpfulcampfires$cachedEffectType = null;
    @Unique
    private int helpfulcampfires$cachedLightLevel = -1;
    @Unique
    private static final Map<Player, BlockPos> helpfulcampfires$playerCampfireMap = new HashMap<Player, BlockPos>();

    @Inject(method={"cookTick"}, at={@At(value="TAIL")})
    private static void helpfulcampfires$runEveryTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo ci) {
        if (level.isClientSide() || !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            return;
        }
        CampfireBlockEntityMixin mixin = (CampfireBlockEntityMixin)blockEntity;
        if (mixin == null) {
            return;
        }
        Player closestPlayer = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 32.0, false);
        if (closestPlayer == null) {
            return;
        }
        BlockPos closestCampfire = CampfireBlockEntityMixin.helpfulcampfires$findClosestBlockInHearingRange(level, closestPlayer, CampfireBlock.class, 32);
        if (closestCampfire == null || !closestCampfire.equals((Object)pos)) {
            return;
        }
        long currentTime = level.getGameTime();
        if (mixin.helpfulcampfires$firstLitTime == 0L) {
            mixin.helpfulcampfires$firstLitTime = currentTime;
        }
        if (mixin.helpfulcampfires$cachedEffectType == null) {
            mixin.helpfulcampfires$determineCampfireType(state);
        }
        boolean hasPlayersInRange = mixin.helpfulcampfires$checkAndHandleEffects(level, pos, mixin.helpfulcampfires$cachedEffectType);
        CampfireBlockEntityMixin.helpfulcampfires$handleStatusSounds(level, pos, mixin, hasPlayersInRange, currentTime);
        if (hasPlayersInRange) {
            CampfireBlockEntityMixin.helpfulcampfires$handleAmbientSounds(level, pos, mixin, currentTime);
        }
    }

    @Unique
    private void helpfulcampfires$determineCampfireType(BlockState state) {
        int currentLightLevel = state.getLightEmission();
        if (this.helpfulcampfires$cachedEffectType == null || currentLightLevel != this.helpfulcampfires$cachedLightLevel) {
            this.helpfulcampfires$cachedLightLevel = currentLightLevel;
            this.helpfulcampfires$cachedEffectType = currentLightLevel == 10 ? MobEffects.JUMP : MobEffects.REGENERATION;
        }
    }

    @Unique
    private static void helpfulcampfires$handleStatusSounds(Level level, BlockPos pos, CampfireBlockEntityMixin mixin, boolean hasPlayersInRange, long currentTime) {
        if (hasPlayersInRange == mixin.helpfulcampfires$wasActive || currentTime - mixin.helpfulcampfires$lastStatusChange <= 10L) {
            return;
        }
        level.playSound(null, pos, hasPlayersInRange ? HelpfulCampfiresMod.SWELL_IN.get() : HelpfulCampfiresMod.SWELL_OUT.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
        mixin.helpfulcampfires$lastStatusChange = currentTime;
        mixin.helpfulcampfires$wasActive = hasPlayersInRange;
    }

    @Unique
    private static void helpfulcampfires$handleAmbientSounds(Level level, BlockPos pos, CampfireBlockEntityMixin mixin, long currentTime) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.getRandom().nextFloat() < 0.11f) {
                if (mixin.helpfulcampfires$cachedEffectType == MobEffects.REGENERATION) {
                    double x = (double)pos.getX() + 0.5;
                    double y = (double)pos.getY() + 0.8;
                    double z = (double)pos.getZ() + 0.5;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, 0.2, 0.2, 0.2, 0.025);
                } else {
                    double x = (double)pos.getX() + 0.5;
                    double y = (double)pos.getY() + 0.8;
                    double z = (double)pos.getZ() + 0.5;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, x, y, z, 1, 0.3, 0.2, 0.3, 0.02);
                }
            }
        }
        if (currentTime - mixin.helpfulcampfires$firstLitTime < 50L) {
            return;
        }
        if (currentTime >= mixin.helpfulcampfires$nextAmbientFire) {
            level.playSound(null, pos, HelpfulCampfiresMod.FIRE_CRACKLING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            mixin.helpfulcampfires$nextAmbientFire = currentTime + 180L;
        }
        if (currentTime - mixin.helpfulcampfires$firstLitTime < 100L) {
            return;
        }
        if (currentTime > mixin.helpfulcampfires$nextAmbientSound && level.getGameTime() > 13000L) {
            mixin.helpfulcampfires$nextAmbientSound = currentTime + 500L + (long)level.getRandom().nextInt(100);
            BlockPos soundPos = pos.offset(level.getRandom().nextIntBetweenInclusive(-10, 10), level.getRandom().nextIntBetweenInclusive(-10, 10), level.getRandom().nextIntBetweenInclusive(-10, 10));
            level.playSound(null, soundPos, HelpfulCampfiresMod.OWL_Hooting.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
    }

    @Unique
    private boolean helpfulcampfires$checkAndHandleEffects(Level level, BlockPos pos, Holder<MobEffect> effectType) {
        AABB effectArea = new AABB(pos).inflate(9.0);
        List players = level.getEntitiesOfClass(Player.class, effectArea);
        if (players.isEmpty()) {
            return false;
        }
        boolean hasPlayersInRange = false;
        for (Player player : players) {
            double distanceSq = pos.distSqr((Vec3i)player.blockPosition());
            if (distanceSq <= 16.0) {
                hasPlayersInRange = true;
                if (player.hasEffect(effectType)) continue;
                player.addEffect(new MobEffectInstance(effectType, 100, 1, true, false));
                continue;
            }
            if (!(distanceSq <= 81.0)) continue;
            player.removeEffect(effectType);
        }
        return hasPlayersInRange;
    }

    @Unique
    private static BlockPos helpfulcampfires$findClosestBlockInHearingRange(Level level, Player player, Class<?> blockClass, int hearingRadius) {
        long currentTime = level.getGameTime();
        if (currentTime - helpfulcampfires$lastGlobalHearingCheck > 40L) {
            helpfulcampfires$lastGlobalHearingCheck = currentTime;
            helpfulcampfires$playerCampfireMap.entrySet().removeIf(entry -> ((Player)entry.getKey()).isRemoved() || !((Player)entry.getKey()).isAlive());
            BlockPos currentClosest = helpfulcampfires$playerCampfireMap.get(player);
            BlockPos playerPos = player.blockPosition();
            if (currentClosest != null && playerPos.distSqr((Vec3i)currentClosest) <= 16.0) {
                return currentClosest;
            }
            BlockPos closestPos = null;
            double closestDistanceSq = Double.MAX_VALUE;
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
            for (int x = -hearingRadius; x <= hearingRadius; ++x) {
                for (int y = -hearingRadius; y <= hearingRadius; ++y) {
                    for (int z = -hearingRadius; z <= hearingRadius; ++z) {
                        double distanceSq;
                        checkPos.set(playerPos.getX() + x, playerPos.getY() + y, playerPos.getZ() + z);
                        BlockState blockState = level.getBlockState((BlockPos)checkPos);
                        if (!blockClass.isInstance(blockState.getBlock()) || !((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue() || !((distanceSq = playerPos.distSqr((Vec3i)checkPos)) < closestDistanceSq)) continue;
                        closestDistanceSq = distanceSq;
                        closestPos = checkPos.immutable();
                    }
                }
            }
            helpfulcampfires$playerCampfireMap.put(player, closestPos);
        }
        return helpfulcampfires$playerCampfireMap.get(player);
    }

    @Inject(method={"dowse"}, at={@At(value="HEAD")})
    private void helpfulcampfires$onDowse(CallbackInfo ci) {
        this.helpfulcampfires$firstLitTime = 0L;
        this.helpfulcampfires$nextAmbientFire = 0L;
        this.helpfulcampfires$wasActive = false;
    }
}

