/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.helpfulcampfires.registry;

import com.khazoda.helpfulcampfires.Constants;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Reggie<T> {
    private final ResourceKey<? extends Registry<? extends T>> key;
    private final Map<ResourceLocation, Supplier<? extends T>> registryEntries = new Object2ObjectLinkedOpenHashMap();

    public Reggie(ResourceKey<? extends Registry<? extends T>> key) {
        this.key = key;
    }

    public <T2 extends T> Supplier<T2> register(String path, final Supplier<T2> supplier) {
        ResourceLocation name = Constants.ID(path);
        if (this.registryEntries.containsKey(name)) {
            throw new IllegalArgumentException("<! Can't register " + String.valueOf(name) + " twice !>");
        }
        Supplier memoized = new Supplier<T2>(this){
            @Nullable
            private T2 cacheVal;

            @Override
            public T2 get() {
                Object val = this.cacheVal;
                if (val == null) {
                    this.cacheVal = val = supplier.get();
                }
                return val;
            }
        };
        this.registryEntries.put(name, memoized);
        return memoized;
    }

    public void registerAll(Registry<? super T> registry) {
        if (this.key != registry.key()) {
            return;
        }
        for (Map.Entry<ResourceLocation, Supplier<T>> entry : this.registryEntries.entrySet()) {
            Registry.register(registry, (ResourceLocation)entry.getKey(), entry.getValue().get());
        }
    }
}

