/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.helpfulcampfires.mixin;

import com.khazoda.helpfulcampfires.mixinutils.CampfireData;
import com.khazoda.helpfulcampfires.registry.SoundRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3924.class})
public class CampfireBlockEntityMixin {
    @Unique
    private static final int EFFECT_RADIUS = 4;
    @Unique
    private static final int EFFECT_REMOVAL_RADIUS = 9;
    @Unique
    private static final int GRACE_PERIOD_TICKS = 10;
    @Unique
    private static final int MIN_SHORT_AMBIENT_DELAY = 500;
    @Unique
    private static final int MAX_EXTRA_AMBIENT_DELAY = 100;
    @Unique
    private static final int INITIAL_SOUND_DELAY = 100;
    @Unique
    private static final int HEARING_RADIUS = 8;
    @Unique
    private static final int EFFECT_RADIUS_SQ = 16;
    @Unique
    private static final int EFFECT_REMOVAL_RADIUS_SQ = 81;
    @Unique
    private static final Map<class_2338, CampfireData> helpfulcampfires$campfireData = new ConcurrentHashMap<class_2338, CampfireData>();
    @Unique
    private static final Map<class_1657, class_2338> helpfulcampfires$playerCampfireMap = new ConcurrentHashMap<class_1657, class_2338>();
    @Unique
    private static long helpfulcampfires$lastGlobalHearingCheck = 0L;

    @Inject(method={"cookTick"}, at={@At(value="TAIL")})
    private static void helpfulcampfires$runEveryTick(class_1937 level, class_2338 pos, class_2680 state, class_3924 blockEntity, CallbackInfo ci) {
        if (level.method_8608() || !((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            return;
        }
        class_1657 closestPlayer = level.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 8.0, false);
        if (closestPlayer == null) {
            return;
        }
        class_2338 activeCampfire = CampfireBlockEntityMixin.helpfulcampfires$findActiveCampfireForPlayer(level, closestPlayer);
        if (!pos.equals((Object)activeCampfire)) {
            return;
        }
        CampfireData data = helpfulcampfires$campfireData.computeIfAbsent(pos, k -> new CampfireData());
        CampfireBlockEntityMixin.helpfulcampfires$updateCampfireType(state, data);
        boolean hasPlayersInRange = CampfireBlockEntityMixin.helpfulcampfires$checkAndHandleEffects(level, pos, data.effectType);
        long currentTime = level.method_8510();
        CampfireBlockEntityMixin.helpfulcampfires$handleCampfireSoundsAndParticles(level, pos, data, hasPlayersInRange, currentTime);
    }

    @Unique
    private static class_2338 helpfulcampfires$findActiveCampfireForPlayer(class_1937 level, class_1657 player) {
        long currentTime = level.method_8510();
        if (currentTime - helpfulcampfires$lastGlobalHearingCheck > 40L) {
            helpfulcampfires$lastGlobalHearingCheck = currentTime;
            helpfulcampfires$playerCampfireMap.entrySet().removeIf(entry -> ((class_1657)entry.getKey()).method_31481() || !((class_1657)entry.getKey()).method_5805() || ((class_1657)entry.getKey()).method_37908() != level);
            class_2338 currentActive = helpfulcampfires$playerCampfireMap.get(player);
            class_2338 playerPos = player.method_24515();
            if (currentActive != null && playerPos.method_10262((class_2382)currentActive) <= 16.0) {
                return currentActive;
            }
            class_2338 closestCampfire = null;
            double closestDistanceSq = Double.MAX_VALUE;
            class_2338.class_2339 checkPos = new class_2338.class_2339();
            for (int x = -8; x <= 8; ++x) {
                for (int y = -8; y <= 8; ++y) {
                    for (int z = -8; z <= 8; ++z) {
                        double distanceSq;
                        checkPos.method_10103(playerPos.method_10263() + x, playerPos.method_10264() + y, playerPos.method_10260() + z);
                        class_2680 blockState = level.method_8320((class_2338)checkPos);
                        if (!(blockState.method_26204() instanceof class_3922) || !((Boolean)blockState.method_11654((class_2769)class_3922.field_17352)).booleanValue() || !((distanceSq = playerPos.method_10262((class_2382)checkPos)) < closestDistanceSq)) continue;
                        closestDistanceSq = distanceSq;
                        closestCampfire = checkPos.method_10062();
                    }
                }
            }
            helpfulcampfires$playerCampfireMap.put(player, closestCampfire);
            return closestCampfire;
        }
        return helpfulcampfires$playerCampfireMap.get(player);
    }

    @Unique
    private static void helpfulcampfires$updateCampfireType(class_2680 state, CampfireData data) {
        int currentLightLevel = state.method_26213();
        if (data.effectType == null || currentLightLevel != data.lightLevel) {
            data.lightLevel = currentLightLevel;
            data.effectType = currentLightLevel == 10 ? class_1294.field_5913 : class_1294.field_5924;
        }
    }

    @Unique
    private static void helpfulcampfires$handleCampfireSoundsAndParticles(class_1937 level, class_2338 pos, CampfireData data, boolean hasPlayersInRange, long currentTime) {
        if (hasPlayersInRange != data.wasActive && currentTime - data.lastStatusChange > 10L) {
            level.method_8396(null, pos, hasPlayersInRange ? SoundRegistry.SWELL_IN.get() : SoundRegistry.SWELL_OUT.get(), class_3419.field_15245, 0.25f, 1.0f);
            data.lastStatusChange = currentTime;
            data.wasActive = hasPlayersInRange;
        }
        if (hasPlayersInRange) {
            CampfireBlockEntityMixin.helpfulcampfires$handleAmbientEffects(level, pos, data, currentTime);
        }
    }

    @Unique
    private static void helpfulcampfires$handleAmbientEffects(class_1937 level, class_2338 pos, CampfireData data, long currentTime) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (level.method_8409().method_43057() < 0.11f) {
                double x = (double)pos.method_10263() + 0.5;
                double y = (double)pos.method_10264() + 0.8;
                double z = (double)pos.method_10260() + 0.5;
                if (data.effectType == class_1294.field_5924) {
                    serverLevel.method_14199((class_2394)class_2398.field_11240, x, y, z, 1, 0.2, 0.2, 0.2, 0.025);
                } else {
                    serverLevel.method_14199((class_2394)class_2398.field_23114, x, y, z, 1, 0.3, 0.2, 0.3, 0.02);
                }
            }
        }
        if (currentTime - data.firstLitTime >= 50L && currentTime >= data.nextAmbientFire) {
            level.method_8396(null, pos, SoundRegistry.FIRE_CRACKLING.get(), class_3419.field_15245, 0.8f, 1.0f);
            data.nextAmbientFire = currentTime + 180L;
        }
        if (currentTime - data.firstLitTime >= 100L && currentTime > data.nextAmbientSound && level.method_23886()) {
            data.nextAmbientSound = currentTime + 500L + (long)level.method_8409().method_43048(100);
            class_2338 soundPos = pos.method_10069(level.method_8409().method_39332(-10, 10), level.method_8409().method_39332(-10, 10), level.method_8409().method_39332(-10, 10));
            level.method_8396(null, soundPos, SoundRegistry.OWL_Hooting.get(), class_3419.field_15245, 0.6f, 1.0f);
        }
    }

    @Unique
    private static boolean helpfulcampfires$checkAndHandleEffects(class_1937 level, class_2338 pos, class_6880<class_1291> effectType) {
        class_238 effectArea = new class_238(pos).method_1014(9.0);
        List players = level.method_18467(class_1657.class, effectArea);
        if (players.isEmpty()) {
            return false;
        }
        boolean hasPlayersInRange = false;
        for (class_1657 player : players) {
            double distanceSq = pos.method_10262((class_2382)player.method_24515());
            if (distanceSq <= 16.0 && effectType != null) {
                hasPlayersInRange = true;
                if (player.method_6059(effectType)) continue;
                player.method_6092(new class_1293(effectType, 100, 1, true, false));
                continue;
            }
            if (!(distanceSq <= 81.0)) continue;
            player.method_6016(effectType);
        }
        return hasPlayersInRange;
    }

    @Inject(method={"dowse"}, at={@At(value="HEAD")})
    private void helpfulcampfires$onDowse(CallbackInfo ci) {
        class_2338 pos = ((class_3924)this).method_11016();
        helpfulcampfires$campfireData.remove(pos);
        helpfulcampfires$playerCampfireMap.entrySet().removeIf(entry -> pos.equals(entry.getValue()));
    }
}

