/*
 * Decompiled with CFR 0.152.
 */
package com.github.cargocats.util;

import com.github.cargocats.DisplayDelight;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class DisplayDelightAssociations {
    public static final ConcurrentHashMap<class_2960, class_2248> BLOCK_CACHE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<class_2960, class_1792> ITEM_CACHE = new ConcurrentHashMap();
    private static final ArrayList<String> allPrefixes = new ArrayList<String>(List.of("small_plated_", "plated_"));
    private static final String[] typePrefixes = new String[]{"plated_", "small_plated_", ""};
    private static final Map<String, String> COMPAT_NAMESPACES = new HashMap<String, String>(){
        {
            this.put("vna_", "minecraft");
            this.put("od_", "oceansdelight");
            this.put("pd_", "pineapple_delight");
            this.put("cd_", "corndelight");
        }
    };

    public static class_2248 getSmallPlateBlockForItem(class_1792 item) {
        return DisplayDelightAssociations.getPrefixedBlockForItem(item, "small_plated_");
    }

    public static class_2248 getPlateBlockForItem(class_1792 item) {
        return DisplayDelightAssociations.getPrefixedBlockForItem(item, "plated_");
    }

    public static class_2248 getDisplayBlockForItem(class_1792 item) {
        return DisplayDelightAssociations.getPrefixedBlockForItem(item, "");
    }

    public static class_2248 getPrefixedBlockForItem(class_1792 item, String prefix) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        class_2960 cacheKey = itemId.method_45138(prefix);
        class_2248 cached = BLOCK_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        class_2960 translatedId = DisplayDelight.id(DisplayDelightAssociations.getNamespace(itemId.method_12836()) + prefix + itemId.method_12832());
        Optional optBlock = class_7923.field_41175.method_17966(translatedId);
        class_2248 block = optBlock.orElse(class_2246.field_10124);
        if (block.equals(class_2246.field_10124)) {
            DisplayDelight.LOG.warn("Could not find prefix {} block {} for item {}", new Object[]{prefix, translatedId, item});
        }
        BLOCK_CACHE.put(cacheKey, block);
        return block;
    }

    public static class_1792 getFoodItem(class_2960 foodItemId) {
        class_1792 cached = ITEM_CACHE.get(foodItemId);
        if (cached != null) {
            return cached;
        }
        class_2960 translatedId = class_2960.method_60655((String)foodItemId.method_12836(), (String)DisplayDelightAssociations.removeFirstPrefix(foodItemId.method_12832()));
        Optional optItem = class_7923.field_41178.method_17966(translatedId);
        class_1792 foodItem = optItem.orElse(class_1802.field_8162);
        if (foodItem.equals(class_1802.field_8162)) {
            DisplayDelight.LOG.warn("Could not find item from registry with food item id: {}", (Object)foodItemId);
        }
        ITEM_CACHE.put(foodItemId, foodItem);
        return foodItem;
    }

    public static class_2960 getId(String name) {
        return class_2960.method_60655((String)DisplayDelightAssociations.getLongNamespace(DisplayDelightAssociations.getPrefix(name)), (String)DisplayDelightAssociations.removeFirstPrefix(name));
    }

    private static String removeFirstPrefix(String path) {
        for (String prefix : allPrefixes) {
            if (prefix.isEmpty() || !path.startsWith(prefix)) continue;
            return path.substring(prefix.length());
        }
        return path;
    }

    public static String getNamespace(String prefix) {
        for (String key : COMPAT_NAMESPACES.keySet()) {
            if (!COMPAT_NAMESPACES.get(key).equals(prefix)) continue;
            return key;
        }
        return "";
    }

    public static String getLongNamespace(String prefix) {
        for (String key : COMPAT_NAMESPACES.keySet()) {
            if (!prefix.startsWith(key)) continue;
            return COMPAT_NAMESPACES.get(key);
        }
        return "farmersdelight";
    }

    public static String getPrefix(String id) {
        int firstUnderscore = id.indexOf("_");
        if (firstUnderscore == -1) {
            return id;
        }
        return id.substring(0, firstUnderscore + 1);
    }

    public static void init() {
        for (String compatNamespaces : COMPAT_NAMESPACES.keySet()) {
            for (String typePrefix : typePrefixes) {
                allPrefixes.add(compatNamespaces + typePrefix);
            }
        }
    }
}

