/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.item;

import com.yomi.mtryum.registry.MtryumItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class LiftFloorSetterItem {
    private static final String ELEVATOR_FLOOR_ID = "mtr:lift_track_floor_1";
    private static final String ELEVATOR_TRACK_ID = "mtr:lift_track_1";
    private static final String FLOOR_NBT_KEY = "floor_number";
    private static final String SOUND_PLAYER_BLOCK_ID = "mtryum:lift_arrival_sound_player";
    private static final String SOUND_INDEX_NBT_KEY = "sound_index";

    public static class_1269 onBlockUse(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_31574(MtryumItems.LIFT_FLOOR_SETTER)) {
            return class_1269.field_5811;
        }
        class_2338 startPos = hitResult.method_17777();
        class_2680 state = world.method_8320(startPos);
        String blockId = class_2378.field_11146.method_10221((Object)state.method_26204()).toString();
        if (blockId.equals(SOUND_PLAYER_BLOCK_ID)) {
            int selectedSound = LiftFloorSetterItem.getSoundIndexFromBlockEntity(world, startPos);
            if (selectedSound > 0) {
                LiftFloorSetterItem.processSoundPlayerChain(world, startPos, selectedSound);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (!blockId.equals(ELEVATOR_FLOOR_ID)) {
            return class_1269.field_5811;
        }
        LiftFloorSetterItem.processElevatorChain(world, startPos);
        return class_1269.field_5812;
    }

    private static int getSoundIndexFromBlockEntity(class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be == null) {
            return -1;
        }
        class_2487 nbt = be.method_38242();
        return nbt.method_10545(SOUND_INDEX_NBT_KEY) ? nbt.method_10550(SOUND_INDEX_NBT_KEY) : -1;
    }

    private static void processSoundPlayerChain(class_1937 world, class_2338 startPos, int soundIndex) {
        int minY = startPos.method_10264();
        int maxY = 315;
        for (int y = minY; y <= maxY; ++y) {
            class_2338 pos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            class_2680 state = world.method_8320(pos);
            String blockId = class_2378.field_11146.method_10221((Object)state.method_26204()).toString();
            if (!blockId.equals(SOUND_PLAYER_BLOCK_ID)) continue;
            LiftFloorSetterItem.updateSoundIndexNBT(world, pos, soundIndex);
        }
    }

    private static void updateSoundIndexNBT(class_1937 world, class_2338 pos, int soundIndex) {
        class_2586 be = world.method_8321(pos);
        if (be == null) {
            return;
        }
        class_2487 originalNbt = be.method_38242();
        class_2487 newNbt = originalNbt.method_10553();
        newNbt.method_10569(SOUND_INDEX_NBT_KEY, soundIndex);
        if (originalNbt.method_10550(SOUND_INDEX_NBT_KEY) != soundIndex) {
            be.method_11014(newNbt);
            be.method_5431();
            world.method_8413(pos, be.method_11010(), be.method_11010(), 3);
        }
    }

    private static void processElevatorChain(class_1937 world, class_2338 startPos) {
        int currentFloor = 1;
        class_2338 currentPos = startPos;
        while (true) {
            class_2680 state;
            String blockId;
            if (!(blockId = class_2378.field_11146.method_10221((Object)(state = world.method_8320(currentPos)).method_26204()).toString()).equals(ELEVATOR_FLOOR_ID)) {
                if (!blockId.equals(ELEVATOR_TRACK_ID)) break;
                currentPos = currentPos.method_10084();
                continue;
            }
            LiftFloorSetterItem.updateFloorNBT(world, currentPos, currentFloor++);
            currentPos = currentPos.method_10084();
        }
    }

    private static void updateFloorNBT(class_1937 world, class_2338 pos, int floorNumber) {
        class_2586 be = world.method_8321(pos);
        if (be == null) {
            return;
        }
        class_2487 originalNbt = be.method_38242();
        class_2487 newNbt = originalNbt.method_10553();
        String formattedFloor = String.valueOf(floorNumber);
        newNbt.method_10582(FLOOR_NBT_KEY, formattedFloor);
        if (!formattedFloor.equals(originalNbt.method_10558(FLOOR_NBT_KEY))) {
            be.method_11014(newNbt);
            be.method_5431();
            world.method_8413(pos, be.method_11010(), be.method_11010(), 3);
        }
    }
}

