/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.block;

import com.yomi.mtryum.registry.MtryumBlockEntities;
import mtr.block.BlockLiftPanelBase;
import mtr.data.Lift;
import mtr.data.RailwayData;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MitsubishiStyleLiftButtonsBlockEntity
extends BlockLiftPanelBase.TileEntityLiftPanel1Base {
    private static final String KEY_UP_PRESSED = "up_pressed";
    private static final String KEY_DOWN_PRESSED = "down_pressed";
    private boolean upButtonPressed;
    private boolean downButtonPressed;
    private Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MSLB");

    public MitsubishiStyleLiftButtonsBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, false);
    }

    public MitsubishiStyleLiftButtonsBlockEntity(class_2338 pos, class_2680 state) {
        this(MtryumBlockEntities.MITSUBISHI_STYLE_LIFT_BUTTONS_ENTITY, pos, state);
    }

    public void readCompoundTag(class_2487 compoundTag) {
        super.readCompoundTag(compoundTag);
        this.upButtonPressed = compoundTag.method_10577(KEY_UP_PRESSED);
        this.downButtonPressed = compoundTag.method_10577(KEY_DOWN_PRESSED);
    }

    public void writeCompoundTag(class_2487 compoundTag) {
        super.writeCompoundTag(compoundTag);
        compoundTag.method_10556(KEY_UP_PRESSED, this.upButtonPressed);
        compoundTag.method_10556(KEY_DOWN_PRESSED, this.downButtonPressed);
    }

    public void callLift(boolean callUp) {
        class_2338 trackPos;
        if (this.field_11863 != null && !this.field_11863.field_9236 && (trackPos = this.getTrackPosition(this.field_11863)) != null) {
            RailwayData railwayData = RailwayData.getInstance((class_1937)this.field_11863);
            if (railwayData != null) {
                for (Lift lift : railwayData.lifts) {
                    if (!lift.hasFloor(trackPos)) continue;
                    lift.pressButton(trackPos.method_10264());
                    if (callUp) {
                        this.upButtonPressed = true;
                    } else {
                        this.downButtonPressed = true;
                    }
                    this.method_5431();
                    this.syncData();
                    return;
                }
            } else {
                LOGGER.error("MTRYUM Call lift:RailwayData is null");
            }
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, MitsubishiStyleLiftButtonsBlockEntity entity) {
        RailwayData railwayData;
        class_2338 trackPos;
        if (level != null && !level.field_9236 && (trackPos = entity.getTrackPosition(level)) != null && (railwayData = RailwayData.getInstance((class_1937)level)) != null) {
            for (Lift lift : railwayData.lifts) {
                class_2338 currentFloor;
                if (!lift.hasFloor(trackPos) || (currentFloor = lift.getCurrentFloorBlockPos()) == null || !currentFloor.equals((Object)trackPos)) continue;
                entity.liftArrived();
                break;
            }
        }
    }

    public void liftArrived() {
        if (this.field_11863 == null) {
            LOGGER.error("MTRYUM liftArrived:Level is null");
            return;
        }
        this.upButtonPressed = false;
        this.downButtonPressed = false;
        this.method_5431();
        this.syncData();
    }

    public boolean isUpButtonPressed() {
        return this.upButtonPressed;
    }

    public boolean isDownButtonPressed() {
        return this.downButtonPressed;
    }

    public void updateLiftDirection(Lift.LiftDirection direction) {
        this.liftDirection = direction;
    }
}

