/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.item;

import com.yomi.mtryum.block.LiftArrivalLightBlock;
import com.yomi.mtryum.block.LiftArrivalSoundPlayerBlock;
import com.yomi.mtryum.block.MitsubishiStyleLiftButtonsBlock;
import java.util.List;
import mtr.block.BlockLiftButtons;
import mtr.block.BlockLiftPanelBase;
import mtr.block.BlockLiftTrackFloor;
import mtr.item.ItemLiftButtonsLinkModifier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiftAutoConnectorItem
extends ItemLiftButtonsLinkModifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"LiftAutoConnector");
    private static final String KEY_OFFSET = "offset";
    private static final int MAX_FLOORS = 512;
    private static final String LIFT_TRACK_ID = "mtr:lift_track_floor_1";
    private static final String BUTTON_ID = "mtr:lift_buttons_1";
    private static final String ID1 = "mtryum:lift_arrival_sound_player";
    private static final String ID2 = "mtryum:mitsubishi_style_lift_buttons";
    private static final String ID3 = "mtr:lift_panel_odd_1";
    private static final String ID4 = "mtr:lift_panel_odd_2";
    private static final String ID5 = "mtryum:lift_arrival_light";

    public LiftAutoConnectorItem() {
        super(true);
    }

    protected void onStartClick(class_1838 context, class_2487 compoundTag) {
    }

    protected void onEndClick(class_1838 context, class_2338 posEnd, class_2487 compoundTag) {
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_2680 state = world.method_8320(clickedPos);
        if (world.field_9236) {
            return;
        }
        try {
            class_2960 clickedblockId = class_2378.field_11146.method_10221((Object)state.method_26204());
            if (LIFT_TRACK_ID.equals(clickedblockId.toString())) {
                this.handleTrackConnection(context, compoundTag, clickedPos);
            } else if (this.isConnectableBlock(clickedblockId)) {
                this.handleDeviceConnection(context, world, compoundTag, clickedPos);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u64cd\u4f5c\u5931\u8d25: ", (Throwable)e);
        }
    }

    private void handleTrackConnection(class_1838 context, class_2487 compoundTag, class_2338 trackPos) {
        compoundTag.method_10544("base_track", trackPos.method_10063());
        if (context.method_8036() != null) {
            context.method_8036().method_7353((class_2561)new class_2588("msg.mtryum.track_selected", new Object[]{trackPos.method_10263(), trackPos.method_10264(), trackPos.method_10260()}), false);
        }
        LOGGER.info("\u57fa\u51c6\u8f68\u9053\u5df2\u8bb0\u5f55: {}", (Object)trackPos);
    }

    private void handleDeviceConnection(class_1838 context, class_1937 level, class_2487 compoundTag, class_2338 buttonPos) {
        class_2338 upperTrack;
        if (!compoundTag.method_10545("base_track")) {
            LOGGER.warn("\u672a\u68c0\u6d4b\u5230\u57fa\u51c6\u8f68\u9053\u6570\u636e");
            if (context.method_8036() != null) {
                context.method_8036().method_7353((class_2561)new class_2588("msg.mtryum.no_base_track"), false);
            }
            return;
        }
        class_2338 baseTrack = class_2338.method_10092((long)compoundTag.method_10537("base_track"));
        if (!(level.method_8320(baseTrack).method_26204() instanceof BlockLiftTrackFloor)) {
            LOGGER.error("\u57fa\u51c6\u8f68\u9053\u5df2\u5931\u6548: {}", (Object)baseTrack);
            if (context.method_8036() != null) {
                context.method_8036().method_7353((class_2561)new class_2588("msg.mtryum.invalid_base_track"), false);
            }
            return;
        }
        class_2338 offset = buttonPos.method_10059((class_2382)baseTrack);
        compoundTag.method_10539(KEY_OFFSET, new int[]{offset.method_10263(), offset.method_10264(), offset.method_10260()});
        LOGGER.info("\u504f\u79fb\u91cf\u8ba1\u7b97: {}", (Object)offset);
        int connected = 0;
        class_2338 currentTrack = baseTrack;
        while (connected < 512 && (upperTrack = this.findNextTrack(level, currentTrack)) != null) {
            class_2338 targetButton = upperTrack.method_10081((class_2382)offset);
            if (this.connectDevice(level, upperTrack, targetButton)) {
                ++connected;
                LOGGER.debug("\u6210\u529f\u8fde\u63a5: {} \u2192 {}", (Object)upperTrack, (Object)targetButton);
            }
            currentTrack = upperTrack;
        }
        if (context.method_8036() != null) {
            context.method_8036().method_7353((class_2561)new class_2588("msg.mtryum.connection_complete", new Object[]{connected}), false);
        }
        compoundTag.method_10551("base_track");
        compoundTag.method_10551(KEY_OFFSET);
    }

    private class_2338 findNextTrack(class_1937 world, class_2338 current) {
        for (int y = 1; y <= 512; ++y) {
            class_2338 checkPos = current.method_10086(y);
            if (!(world.method_8320(checkPos).method_26204() instanceof BlockLiftTrackFloor)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean connectDevice(class_1937 world, class_2338 trackPos, class_2338 buttonPos) {
        try {
            class_2586 be = world.method_8321(buttonPos);
            if (be instanceof BlockLiftButtons.TileEntityLiftButtons) {
                ((BlockLiftButtons.TileEntityLiftButtons)be).registerFloor(trackPos, true);
                return true;
            }
            if (be instanceof BlockLiftPanelBase.TileEntityLiftPanel1Base) {
                ((BlockLiftPanelBase.TileEntityLiftPanel1Base)be).registerFloor(trackPos, true);
                return true;
            }
            if (be instanceof LiftArrivalLightBlock.Entity) {
                ((LiftArrivalLightBlock.Entity)be).registerFloor(trackPos, true);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("\u8fde\u63a5\u5931\u8d25: {} \u2192 {}", (Object)trackPos, (Object)buttonPos, (Object)e);
            return false;
        }
    }

    private boolean isConnectableBlock(class_2960 blockId) {
        String idStr = blockId.toString();
        return idStr.equals(BUTTON_ID) || idStr.equals(ID1) || idStr.equals(ID2) || idStr.equals(ID3) || idStr.equals(ID4) || idStr.equals(ID5);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)new class_2588("tooltip.mtryum.auto_connector.line1").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        tooltip.add((class_2561)new class_2588("tooltip.mtryum.auto_connector.line2").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    protected boolean clickCondition(class_1838 context) {
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        return state.method_26204() instanceof BlockLiftTrackFloor || state.method_26204() instanceof BlockLiftButtons || state.method_26204() instanceof MitsubishiStyleLiftButtonsBlock || state.method_26204() instanceof LiftArrivalLightBlock || state.method_26204() instanceof LiftArrivalSoundPlayerBlock;
    }
}

