/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.render;

import com.yomi.mtryum.block.LiftFloorMonitorBlock;
import com.yomi.mtryum.block.LiftFloorMonitorEntity;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.ClientData;
import mtr.data.Lift;
import net.minecraft.class_1160;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_827;

public class LiftFloorMonitorRenderer
implements class_827<LiftFloorMonitorEntity> {
    private static final float TEXT_OFFSET = 0.00625f;
    private static final float TEXT_SCALE = 0.015f;
    private static final float ARROW_SIZE = 0.25f;
    private static final float ARROW_OFFSET = 0.03f;
    private static final int FRAME_COUNT = 10;
    private static final long FRAME_DURATION = 100L;

    public void render(LiftFloorMonitorEntity entity, float tickDelta, class_4587 matrices, class_4597 buffer, int light, int combinedOverlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        int color = entity.getTextColor();
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        String floorNumber = "--";
        for (Lift lift : ClientData.LIFTS) {
            class_2338 currentFloor;
            class_2586 blockEntity;
            if (!lift.hasFloor(trackPosition) || !((blockEntity = world.method_8321(currentFloor = lift.getCurrentFloorBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) continue;
            floorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            liftDirection = lift.getLiftDirection();
            entity.updateLiftDirection(liftDirection);
            break;
        }
        if (floorNumber.isEmpty()) {
            return;
        }
        matrices.method_22903();
        this.setupTransform(matrices, (class_2350)entity.method_11010().method_11654((class_2769)LiftFloorMonitorBlock.FACING));
        if (entity.isLocked()) {
            this.renderText(matrices, buffer, "STOP", color);
        } else if (entity.getArrowStyle() == 1) {
            switch (liftDirection) {
                case UP: {
                    displayText = floorNumber + "\u2b06";
                    break;
                }
                case DOWN: {
                    displayText = floorNumber + "\u2b07";
                    break;
                }
                default: {
                    displayText = floorNumber + " ";
                }
            }
            this.renderText(matrices, buffer, displayText, color);
        } else {
            switch (liftDirection) {
                case UP: {
                    displayText = floorNumber + "\u25b2";
                    break;
                }
                case DOWN: {
                    displayText = floorNumber + "\u25bc";
                    break;
                }
                default: {
                    displayText = floorNumber + " ";
                }
            }
            this.renderText(matrices, buffer, displayText, color);
        }
        matrices.method_22909();
    }

    private void setupTransform(class_4587 matrices, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                matrices.method_22904(0.47, 0.69, (double)0.00625f);
                matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                break;
            }
            case field_11035: {
                matrices.method_22904(0.47, 0.69, (double)0.99375f);
                matrices.method_22907(class_1160.field_20705.method_23214(0.0f));
                break;
            }
            case field_11034: {
                matrices.method_22904((double)0.99375f, 0.69, 0.47);
                matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
                break;
            }
            case field_11039: {
                matrices.method_22904((double)0.00625f, 0.69, 0.47);
                matrices.method_22907(class_1160.field_20705.method_23214(-90.0f));
            }
        }
        matrices.method_22905(0.015f, 0.015f, 0.015f);
        matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
    }

    private void renderText(class_4587 matrices, class_4597 buffer, String text, int color) {
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        matrices.method_22904((double)((float)(-textWidth) / 2.0f), 0.0, 0.0);
        font.method_27521(text, 0.0f, 0.0f, color, false, matrices.method_23760().method_23761(), buffer, false, 0, 0xF000F0);
    }
}

