/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.render;

import com.yomi.mtryum.block.MitsubishiStyleLiftButtonsBlock;
import com.yomi.mtryum.block.MitsubishiStyleLiftButtonsBlockEntity;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.ClientData;
import mtr.data.Lift;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class MitsubishiStyleLiftButtonsRenderer
implements class_827<MitsubishiStyleLiftButtonsBlockEntity> {
    private static final class_2960 UP_NORMAL = new class_2960("mtryum", "textures/block/lift_button_up_normal.png");
    private static final class_2960 UP_PRESSED = new class_2960("mtryum", "textures/block/lift_button_up_pressed.png");
    private static final class_2960 DOWN_NORMAL = new class_2960("mtryum", "textures/block/lift_button_down_normal.png");
    private static final class_2960 DOWN_PRESSED = new class_2960("mtryum", "textures/block/lift_button_down_pressed.png");
    private static final class_2960 ARROW_UP = new class_2960("mtryum", "textures/block/lift_arrow_up.png");
    private static final class_2960 ARROW_DOWN = new class_2960("mtryum", "textures/block/lift_arrow_down.png");
    private static final float DEPTH_OFFSET = 0.002f;
    private final class_327 font;

    public MitsubishiStyleLiftButtonsRenderer(class_5614.class_5615 ctx) {
        this.font = ctx.method_32143();
    }

    public void render(MitsubishiStyleLiftButtonsBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2338 currentFloor;
        if (entity == null || entity.method_10997() == null) {
            return;
        }
        boolean upPressed = entity.isUpButtonPressed();
        boolean downPressed = entity.isDownButtonPressed();
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        boolean isTopFloor = false;
        boolean isBottomFloor = false;
        int currentFloorY = trackPosition.method_10264();
        String floorNumber = "??";
        for (Lift lift : ClientData.LIFTS) {
            class_2586 blockEntity;
            if (!lift.hasFloor(trackPosition) || !((blockEntity = world.method_8321(currentFloor = lift.getCurrentFloorBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) continue;
            floorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            liftDirection = lift.getLiftDirection();
            entity.updateLiftDirection(liftDirection);
            boolean[] hasButton = new boolean[2];
            lift.hasUpDownButtonForFloor(currentFloorY, hasButton);
            isTopFloor = !hasButton[0];
            isBottomFloor = !hasButton[1];
            break;
        }
        if (floorNumber.isEmpty()) {
            return;
        }
        for (Lift lift : ClientData.LIFTS) {
            if (!lift.hasFloor(trackPosition) || (currentFloor = lift.getCurrentFloorBlockPos()) == null || !currentFloor.equals((Object)trackPosition)) continue;
            entity.liftArrived();
        }
        class_2960 upTexture = upPressed ? UP_PRESSED : UP_NORMAL;
        class_2960 downTexture = downPressed ? DOWN_PRESSED : DOWN_NORMAL;
        class_2680 state = entity.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)MitsubishiStyleLiftButtonsBlock.FACING);
        matrices.method_22903();
        switch (facing) {
            case field_11035: {
                matrices.method_22904(0.0, -0.135, 0.99);
                break;
            }
            case field_11034: {
                matrices.method_22904(0.99, -0.135, 1.0);
                matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
                break;
            }
            case field_11043: {
                matrices.method_22904(1.0, -0.135, 0.01);
                matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                break;
            }
            case field_11039: {
                matrices.method_22904(0.01, -0.135, 0.0);
                matrices.method_22907(class_1160.field_20705.method_23214(270.0f));
            }
        }
        this.renderAllElements(matrices, vertexConsumers, light, overlay, floorNumber, liftDirection, upTexture, downTexture, facing, isTopFloor, isBottomFloor);
        matrices.method_22909();
    }

    private void renderAllElements(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, String floorNumber, Lift.LiftDirection liftDirection, class_2960 upTexture, class_2960 downTexture, class_2350 facing, boolean isTopFloor, boolean isBottomFloor) {
        float BUTTON_Y_UP = 0.48f;
        float BUTTON_Y_DOWN = 0.35f;
        float ARROW_Y = 0.65f;
        float buttonSize = 0.075f;
        this.renderFloorNumber(matrices, vertexConsumers, floorNumber, light);
        if (liftDirection != Lift.LiftDirection.NONE) {
            if (liftDirection == Lift.LiftDirection.UP) {
                this.renderArrow(matrices, vertexConsumers, "\u2191", light);
            } else {
                this.renderArrow(matrices, vertexConsumers, "\u2193", light);
            }
        }
        if (!isTopFloor && isBottomFloor) {
            this.renderQuad(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)upTexture)), 0.3825f, 0.45749998f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 1.0f : 0.0f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 0.0f : 1.0f, light, overlay);
        } else if (!isTopFloor) {
            this.renderQuad(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)upTexture)), 0.4425f, 0.5175f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 1.0f : 0.0f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 0.0f : 1.0f, light, overlay);
        }
        if (!isBottomFloor && isTopFloor) {
            this.renderQuad(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)downTexture)), 0.3725f, 0.4475f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 1.0f : 0.0f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 0.0f : 1.0f, light, overlay);
        } else if (!isBottomFloor) {
            this.renderQuad(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)downTexture)), 0.3125f, 0.3875f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 1.0f : 0.0f, facing == class_2350.field_11035 || facing == class_2350.field_11039 ? 0.0f : 1.0f, light, overlay);
        }
    }

    private void renderFloorNumber(class_4587 matrices, class_4597 vertexConsumers, String floor, int light) {
        matrices.method_22903();
        matrices.method_22905(0.011f, -0.011f, 0.011f);
        matrices.method_22904(47.0, -71.0, 0.0);
        matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
        this.font.method_27521(floor, 0.0f, 0.0f, 16747520, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
        matrices.method_22909();
    }

    private void renderArrow(class_4587 matrices, class_4597 vertexConsumers, String floor, int light) {
        matrices.method_22903();
        matrices.method_22905(0.011f, -0.011f, 0.011f);
        matrices.method_22904(47.0, -83.0, 0.0);
        matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
        this.font.method_27521(floor, 0.0f, 0.0f, 16747520, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
        matrices.method_22909();
    }

    private void renderQuad(class_4587 matrices, class_4588 vertexConsumer, float minY, float maxY, float uStart, float uEnd, int light, int overlay) {
        class_1159 matrix = matrices.method_23760().method_23761();
        class_4581 normal = matrices.method_23760().method_23762();
        float normalZ = 1.0f;
        vertexConsumer.method_22918(matrix, 0.4625f, minY, 0.002f).method_1336(255, 255, 255, 255).method_22913(uStart, 1.0f).method_22922(overlay).method_22916(light).method_23763(normal, 0.0f, 0.0f, normalZ).method_1344();
        vertexConsumer.method_22918(matrix, 0.4625f, maxY, 0.002f).method_1336(255, 255, 255, 255).method_22913(uStart, 0.0f).method_22922(overlay).method_22916(light).method_23763(normal, 0.0f, 0.0f, normalZ).method_1344();
        vertexConsumer.method_22918(matrix, 0.5375f, maxY, 0.002f).method_1336(255, 255, 255, 255).method_22913(uEnd, 0.0f).method_22922(overlay).method_22916(light).method_23763(normal, 0.0f, 0.0f, normalZ).method_1344();
        vertexConsumer.method_22918(matrix, 0.5375f, minY, 0.002f).method_1336(255, 255, 255, 255).method_22913(uEnd, 1.0f).method_22922(overlay).method_22916(light).method_23763(normal, 0.0f, 0.0f, normalZ).method_1344();
    }
}

