/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.render;

import com.yomi.mtryum.block.MLFMBlock;
import com.yomi.mtryum.block.MLFMEntity;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.ClientData;
import mtr.data.Lift;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class MLFMRender
implements class_827<MLFMEntity> {
    private static final float TEXT_OFFSET = 0.00625f;
    private static final float TEXT_SCALE = 0.015f;

    public void render(MLFMEntity entity, float tickDelta, class_4587 matrices, class_4597 buffer, int light, int combinedOverlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        String floorNumber = "--";
        for (Lift lift : ClientData.LIFTS) {
            class_2338 currentFloor;
            class_2586 blockEntity;
            if (!lift.hasFloor(trackPosition) || !((blockEntity = world.method_8321(currentFloor = lift.getCurrentFloorBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) continue;
            floorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            liftDirection = lift.getLiftDirection();
            entity.updateLiftDirection(liftDirection);
            break;
        }
        if (floorNumber.isEmpty()) {
            return;
        }
        matrices.method_22903();
        this.setupTransform(matrices, (class_2350)entity.method_11010().method_11654((class_2769)MLFMBlock.FACING));
        if (entity.isLocked()) {
            this.renderText(matrices, buffer, "STOP " + floorNumber);
        } else {
            this.renderText(matrices, buffer, switch (liftDirection) {
                case Lift.LiftDirection.UP -> "\u2191 " + floorNumber;
                case Lift.LiftDirection.DOWN -> "\u2193 " + floorNumber;
                default -> "  " + floorNumber;
            });
        }
        matrices.method_22909();
    }

    private void setupTransform(class_4587 matrices, class_2350 facing) {
        switch (facing) {
            case field_11043: {
                matrices.method_22904(0.47, 0.675, (double)0.00625f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11035: {
                matrices.method_22904(0.53, 0.675, (double)0.99375f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(0.0f));
                break;
            }
            case field_11034: {
                matrices.method_22904((double)0.99375f, 0.675, 0.47);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11039: {
                matrices.method_22904((double)0.00625f, 0.675, 0.53);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            }
        }
        matrices.method_22905(0.015f, 0.015f, 0.015f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
    }

    private void renderText(class_4587 matrices, class_4597 buffer, String text) {
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        matrices.method_46416((float)(-textWidth) / 2.0f, 0.0f, 0.0f);
        font.method_27521(text, 0.0f, 0.0f, 16747520, false, matrices.method_23760().method_23761(), buffer, class_327.class_6415.field_33993, 0, 0xF000F0);
    }
}

