/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum;

import com.yomi.mtryum.block.LiftArrivalSoundPlayerEntity;
import com.yomi.mtryum.block.LiftFloorMonitorEntity;
import com.yomi.mtryum.network.SetSoundIndexPacket;
import com.yomi.mtryum.registry.MtryumBlockEntities;
import com.yomi.mtryum.registry.MtryumBlocks;
import com.yomi.mtryum.render.LiftArrivalLightRenderer;
import com.yomi.mtryum.render.LiftFloorMonitorRenderer;
import com.yomi.mtryum.render.MLFMRender;
import com.yomi.mtryum.render.MitsubishiStyleLiftButtonsRenderer;
import com.yomi.mtryum.screen.LiftArrivalSoundPlayerScreen;
import com.yomi.mtryum.screen.LiftFloorMonitorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="mtryum", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MtryumClient {
    private static BlockPos pendingFMScreenPos;
    private static BlockPos pendingASPScreenPos;

    public static void scheduleFMScreenOpen(BlockPos pos) {
        pendingFMScreenPos = pos;
    }

    public static void scheduleASPScreenOpen(BlockPos pos) {
        pendingASPScreenPos = pos;
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MtryumBlocks.LIFT_ARRIVAL_LIGHT_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MtryumBlocks.LIFT_ARRIVAL_SOUND_PLAYER_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MtryumBlocks.LIFT_FLOOR_MONITOR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MtryumBlocks.MLFM.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)MtryumBlocks.MITSUBISHI_STYLE_LIFT_BUTTONS.get()), (RenderType)RenderType.m_110463_());
        });
        SetSoundIndexPacket.register();
        MinecraftForge.EVENT_BUS.addListener(MtryumClient::onClientTick);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)MtryumBlockEntities.LIFT_ARRIVAL_LIGHT_BLOCK_ENTITY.get(), LiftArrivalLightRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MtryumBlockEntities.LIFT_FLOOR_MONITOR.get(), ctx -> new LiftFloorMonitorRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)MtryumBlockEntities.MLFM_ENTITY.get(), ctx -> new MLFMRender());
        event.registerBlockEntityRenderer((BlockEntityType)MtryumBlockEntities.MITSUBISHI_STYLE_LIFT_BUTTONS_ENTITY.get(), MitsubishiStyleLiftButtonsRenderer::new);
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91074_ != null && client.f_91080_ == null) {
                BlockEntity entity;
                if (pendingFMScreenPos != null) {
                    if (client.f_91073_ != null && (entity = client.f_91073_.m_7702_(pendingFMScreenPos)) instanceof LiftFloorMonitorEntity) {
                        client.m_91152_((Screen)new LiftFloorMonitorScreen(pendingFMScreenPos));
                    }
                    pendingFMScreenPos = null;
                }
                if (pendingASPScreenPos != null) {
                    if (client.f_91073_ != null && (entity = client.f_91073_.m_7702_(pendingASPScreenPos)) instanceof LiftArrivalSoundPlayerEntity) {
                        client.m_91152_((Screen)new LiftArrivalSoundPlayerScreen(pendingASPScreenPos));
                    }
                    pendingASPScreenPos = null;
                }
            }
        }
    }
}

