/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.block;

import com.yomi.mtryum.registry.MtryumBlockEntities;
import java.util.List;
import mtr.block.BlockLiftPanelBase;
import mtr.mappings.BlockEntityMapper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LiftArrivalLightBlock
extends BlockLiftPanelBase {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Position> POSITION = EnumProperty.m_61587_((String)"position", Position.class);
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private static final ResourceLocation BRUSH_ITEM_ID = ResourceLocation.m_135820_((String)"mtr:brush");
    private static final VoxelShape CENTER_EAST = Block.m_49796_((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    private static final VoxelShape CENTER_WEST = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0);
    private static final VoxelShape CENTER_SOUTH = Block.m_49796_((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);
    private static final VoxelShape CENTER_NORTH = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0);
    private static final VoxelShape RIGHT_EAST = Block.m_49796_((double)15.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0, (double)21.0);
    private static final VoxelShape RIGHT_WEST = Block.m_49796_((double)0.0, (double)3.0, (double)-5.0, (double)1.0, (double)13.0, (double)5.0);
    private static final VoxelShape RIGHT_SOUTH = Block.m_49796_((double)-5.0, (double)3.0, (double)15.0, (double)5.0, (double)13.0, (double)16.0);
    private static final VoxelShape RIGHT_NORTH = Block.m_49796_((double)11.0, (double)3.0, (double)0.0, (double)21.0, (double)13.0, (double)1.0);

    public LiftArrivalLightBlock() {
        super(false, true);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(POSITION, (Comparable)((Object)Position.CENTER))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POSITION, LIT});
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.mtryum.lift_arrival_light.line1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).equals((Object)BRUSH_ITEM_ID)) {
            Position currentPosition = (Position)((Object)state.m_61143_(POSITION));
            world.m_46597_(pos, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)(currentPosition == Position.CENTER ? Position.RIGHT : Position.CENTER))));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Position position = (Position)((Object)state.m_61143_(POSITION));
        if (position == Position.CENTER) {
            return switch (facing) {
                case Direction.EAST -> CENTER_EAST;
                case Direction.WEST -> CENTER_WEST;
                case Direction.SOUTH -> CENTER_SOUTH;
                default -> CENTER_NORTH;
            };
        }
        return switch (facing) {
            case Direction.EAST -> RIGHT_EAST;
            case Direction.WEST -> RIGHT_WEST;
            case Direction.SOUTH -> RIGHT_SOUTH;
            default -> RIGHT_NORTH;
        };
    }

    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new Entity(pos, state);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new Entity(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public static enum Position implements StringRepresentable
    {
        CENTER("center"),
        RIGHT("right");

        private final String name;

        private Position(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static class Entity
    extends BlockLiftPanelBase.TileEntityLiftPanel1Base {
        public Entity(BlockPos pos, BlockState state) {
            super((BlockEntityType)MtryumBlockEntities.LIFT_ARRIVAL_LIGHT_BLOCK_ENTITY.get(), pos, state, false);
        }
    }
}

