/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.block;

import com.yomi.mtryum.registry.MtryumBlockEntities;
import com.yomi.mtryum.registry.MtryumSounds;
import mtr.block.BlockLiftPanelBase;
import mtr.data.Lift;
import mtr.data.RailwayData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiftArrivalSoundPlayerEntity
extends BlockLiftPanelBase.TileEntityLiftPanel1Base {
    private static final Logger LOGGER = LogManager.getLogger((String)"LiftArrivalSoundPlayer");
    private boolean hasPlayed = false;
    private int soundIndex = 1;

    public LiftArrivalSoundPlayerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MtryumBlockEntities.LIFT_ARRIVAL_SOUND_PLAYER_ENTITY.get(), pos, state, false);
    }

    public void readCompoundTag(CompoundTag compoundTag) {
        super.readCompoundTag(compoundTag);
        if (compoundTag.m_128441_("sound_index")) {
            this.soundIndex = compoundTag.m_128451_("sound_index");
        }
    }

    public void writeCompoundTag(CompoundTag compoundTag) {
        super.writeCompoundTag(compoundTag);
        compoundTag.m_128405_("sound_index", this.soundIndex);
    }

    public void playArrivalSound() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        switch (this.soundIndex) {
            case 1: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_1.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_2.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_3.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 4: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_4.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_5.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 6: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_6.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 7: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_7.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 8: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_8.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 9: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_9.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            default: {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)MtryumSounds.LIFT_ARRIVAL_SOUND_1.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public static void LASPTick(Level level, BlockPos pos, BlockState state, LiftArrivalSoundPlayerEntity entity) {
        Level world = entity.m_58904_();
        if (world == null || world.f_46443_) {
            return;
        }
        BlockPos trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        RailwayData railwayData = RailwayData.getInstance((Level)world);
        if (railwayData == null) {
            return;
        }
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        boolean shouldPlay = false;
        for (Lift lift : railwayData.lifts) {
            if (!lift.hasFloor(trackPosition)) continue;
            BlockPos currentFloor = lift.getCurrentFloorBlockPos();
            liftDirection = lift.getLiftDirection();
            if (currentFloor == null || !currentFloor.equals((Object)trackPosition) || liftDirection != Lift.LiftDirection.NONE) continue;
            shouldPlay = true;
            break;
        }
        if (shouldPlay) {
            if (!entity.hasPlayed) {
                entity.playArrivalSound();
                entity.hasPlayed = true;
            }
        } else {
            entity.hasPlayed = false;
        }
    }

    public int getSoundIndex() {
        return this.soundIndex;
    }

    public void setSoundIndex(int index) {
        this.soundIndex = index;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.setSoundIndexViaCommand(index);
        }
    }

    public void setSoundIndexViaCommand(int index) {
        this.soundIndex = index;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

