/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.block;

import com.yomi.mtryum.MtryumClient;
import com.yomi.mtryum.block.LiftFloorMonitorEntity;
import com.yomi.mtryum.registry.MtryumBlockEntities;
import java.util.List;
import mtr.block.BlockLiftButtons;
import mtr.mappings.BlockEntityMapper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LiftFloorMonitorBlock
extends BlockLiftButtons {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final ResourceLocation BRUSH_ITEM_ID = new ResourceLocation("mtr", "brush");
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)1.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)8.0, (double)15.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape EAST = Block.m_49796_((double)15.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape WEST = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)1.0, (double)12.0, (double)16.0);

    public LiftFloorMonitorBlock() {
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new LiftFloorMonitorEntity((BlockEntityType)MtryumBlockEntities.LIFT_FLOOR_MONITOR.get(), pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.mtryum.floor_monitor.line1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.mtryum.floor_monitor.line2").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (BuiltInRegistries.f_257033_.m_7981_((Object)item).equals((Object)BRUSH_ITEM_ID)) {
            BlockEntity entity;
            if (!world.m_5776_() && (entity = world.m_7702_(pos)) instanceof LiftFloorMonitorEntity) {
                LiftFloorMonitorEntity tile = (LiftFloorMonitorEntity)entity;
                tile.toggleLock();
                world.m_7260_(pos, state, state, 3);
                player.m_5661_((Component)Component.m_237115_((String)(tile.isLocked() ? "msg.mtryum.screen_locked" : "msg.mtryum.screen_unlocked")), true);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (stack.m_41619_() && world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            MtryumClient.scheduleFMScreenOpen(pos);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
    }
}

