/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.block;

import mtr.block.BlockLiftPanelBase;
import mtr.data.Lift;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LiftFloorMonitorEntity
extends BlockLiftPanelBase.TileEntityLiftPanel1Base {
    private BlockPos trackPosition;
    private boolean isLocked = false;
    private int textColor = 0xFF0000;
    private int arrowStyle = 1;
    private Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;

    public LiftFloorMonitorEntity(BlockPos pos, BlockState state) {
        this(null, pos, state);
    }

    public LiftFloorMonitorEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, false);
    }

    public void readCompoundTag(CompoundTag compoundTag) {
        super.readCompoundTag(compoundTag);
        this.trackPosition = compoundTag.m_128441_("track_floor_pos") ? BlockPos.m_122022_((long)compoundTag.m_128454_("track_floor_pos")) : null;
        if (compoundTag.m_128441_("text_color")) {
            this.textColor = compoundTag.m_128451_("text_color");
        }
        if (compoundTag.m_128441_("arrow_style")) {
            this.arrowStyle = compoundTag.m_128451_("arrow_style");
        }
        if (compoundTag.m_128441_("is_locked")) {
            this.isLocked = compoundTag.m_128471_("is_locked");
        }
    }

    public void writeCompoundTag(CompoundTag compoundTag) {
        super.writeCompoundTag(compoundTag);
        if (this.trackPosition != null) {
            compoundTag.m_128356_("track_floor_pos", this.trackPosition.m_121878_());
        }
        compoundTag.m_128379_("is_locked", this.isLocked);
        compoundTag.m_128405_("text_color", this.textColor);
        compoundTag.m_128405_("arrow_style", this.arrowStyle);
    }

    public void registerFloor(BlockPos pos, boolean isAdd) {
        this.trackPosition = isAdd ? pos : null;
        this.m_6596_();
        this.syncData();
    }

    public void toggleLock() {
        this.isLocked = !this.isLocked;
        this.m_6596_();
        this.syncData();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int color) {
        this.textColor = color;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.syncData();
    }

    public BlockPos getTrackPosition(Level world) {
        return this.trackPosition;
    }

    public int getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(int style) {
        this.arrowStyle = Math.max(1, Math.min(2, style));
        this.m_6596_();
        this.syncData();
    }

    public void updateLiftDirection(Lift.LiftDirection direction) {
        this.liftDirection = direction;
    }
}

