/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.block;

import com.yomi.mtryum.registry.MtryumBlockEntities;
import mtr.block.BlockLiftPanelBase;
import mtr.data.Lift;
import mtr.data.RailwayData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MitsubishiStyleLiftButtonsBlockEntity
extends BlockLiftPanelBase.TileEntityLiftPanel1Base {
    private static final String KEY_UP_PRESSED = "up_pressed";
    private static final String KEY_DOWN_PRESSED = "down_pressed";
    private boolean upButtonPressed;
    private boolean downButtonPressed;
    private Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MSLB");

    public MitsubishiStyleLiftButtonsBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, false);
    }

    public MitsubishiStyleLiftButtonsBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)MtryumBlockEntities.MITSUBISHI_STYLE_LIFT_BUTTONS_ENTITY.get(), pos, state);
    }

    public void readCompoundTag(CompoundTag compoundTag) {
        super.readCompoundTag(compoundTag);
        this.upButtonPressed = compoundTag.m_128471_(KEY_UP_PRESSED);
        this.downButtonPressed = compoundTag.m_128471_(KEY_DOWN_PRESSED);
    }

    public void writeCompoundTag(CompoundTag compoundTag) {
        super.writeCompoundTag(compoundTag);
        compoundTag.m_128379_(KEY_UP_PRESSED, this.upButtonPressed);
        compoundTag.m_128379_(KEY_DOWN_PRESSED, this.downButtonPressed);
    }

    public void callLift(boolean callUp) {
        BlockPos trackPos;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (trackPos = this.getTrackPosition(this.f_58857_)) != null) {
            RailwayData railwayData = RailwayData.getInstance((Level)this.f_58857_);
            if (railwayData != null) {
                for (Lift lift : railwayData.lifts) {
                    if (!lift.hasFloor(trackPos)) continue;
                    lift.pressButton(trackPos.m_123342_());
                    if (callUp) {
                        this.upButtonPressed = true;
                    } else {
                        this.downButtonPressed = true;
                    }
                    this.m_6596_();
                    this.syncData();
                    return;
                }
            } else {
                LOGGER.error("MTRYUM Call lift:RailwayData is null");
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MitsubishiStyleLiftButtonsBlockEntity entity) {
        RailwayData railwayData;
        BlockPos trackPos;
        if (level != null && !level.f_46443_ && (trackPos = entity.getTrackPosition(level)) != null && (railwayData = RailwayData.getInstance((Level)level)) != null) {
            for (Lift lift : railwayData.lifts) {
                BlockPos currentFloor;
                if (!lift.hasFloor(trackPos) || (currentFloor = lift.getCurrentFloorBlockPos()) == null || !currentFloor.equals((Object)trackPos)) continue;
                entity.liftArrived();
                break;
            }
        }
    }

    public void liftArrived() {
        if (this.f_58857_ == null) {
            LOGGER.error("MTRYUM liftArrived:Level is null");
            return;
        }
        this.upButtonPressed = false;
        this.downButtonPressed = false;
        this.m_6596_();
        this.syncData();
    }

    public boolean isUpButtonPressed() {
        return this.upButtonPressed;
    }

    public boolean isDownButtonPressed() {
        return this.downButtonPressed;
    }

    public void updateLiftDirection(Lift.LiftDirection direction) {
        this.liftDirection = direction;
    }
}

