/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.item;

import com.yomi.mtryum.block.LiftArrivalLightBlock;
import com.yomi.mtryum.block.LiftArrivalSoundPlayerBlock;
import com.yomi.mtryum.block.MitsubishiStyleLiftButtonsBlock;
import java.util.List;
import mtr.block.BlockLiftButtons;
import mtr.block.BlockLiftPanelBase;
import mtr.block.BlockLiftTrackFloor;
import mtr.item.ItemLiftButtonsLinkModifier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiftAutoConnectorItem
extends ItemLiftButtonsLinkModifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"LiftAutoConnector");
    private static final String KEY_OFFSET = "offset";
    private static final int MAX_FLOORS = 512;
    private static final String LIFT_TRACK_ID = "mtr:lift_track_floor_1";
    private static final String BUTTON_ID = "mtr:lift_buttons_1";
    private static final String ID1 = "mtryum:lift_arrival_sound_player";
    private static final String ID2 = "mtryum:mitsubishi_style_lift_buttons";
    private static final String ID3 = "mtr:lift_panel_odd_1";
    private static final String ID4 = "mtr:lift_panel_odd_2";
    private static final String ID5 = "mtryum:lift_arrival_light";

    public LiftAutoConnectorItem() {
        super(true);
    }

    protected void onStartClick(UseOnContext context, CompoundTag compoundTag) {
    }

    protected void onEndClick(UseOnContext context, BlockPos posEnd, CompoundTag compoundTag) {
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        BlockState state = world.m_8055_(clickedPos);
        if (world.f_46443_) {
            return;
        }
        try {
            ResourceLocation clickedblockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
            if (LIFT_TRACK_ID.equals(clickedblockId.toString())) {
                this.handleTrackConnection(context, compoundTag, clickedPos);
            } else if (this.isConnectableBlock(clickedblockId)) {
                this.handleDeviceConnection(context, world, compoundTag, clickedPos);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u64cd\u4f5c\u5931\u8d25: ", (Throwable)e);
        }
    }

    private void handleTrackConnection(UseOnContext context, CompoundTag compoundTag, BlockPos trackPos) {
        compoundTag.m_128356_("base_track", trackPos.m_121878_());
        if (context.m_43723_() != null) {
            context.m_43723_().m_5661_((Component)Component.m_237110_((String)"msg.mtryum.track_selected", (Object[])new Object[]{trackPos.m_123341_(), trackPos.m_123342_(), trackPos.m_123343_()}), false);
        }
        LOGGER.info("\u57fa\u51c6\u8f68\u9053\u5df2\u8bb0\u5f55: {}", (Object)trackPos);
    }

    private void handleDeviceConnection(UseOnContext context, Level level, CompoundTag compoundTag, BlockPos buttonPos) {
        BlockPos upperTrack;
        if (!compoundTag.m_128441_("base_track")) {
            LOGGER.warn("\u672a\u68c0\u6d4b\u5230\u57fa\u51c6\u8f68\u9053\u6570\u636e");
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"msg.mtryum.no_base_track"), false);
            }
            return;
        }
        BlockPos baseTrack = BlockPos.m_122022_((long)compoundTag.m_128454_("base_track"));
        if (!(level.m_8055_(baseTrack).m_60734_() instanceof BlockLiftTrackFloor)) {
            LOGGER.error("\u57fa\u51c6\u8f68\u9053\u5df2\u5931\u6548: {}", (Object)baseTrack);
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"msg.mtryum.invalid_base_track"), false);
            }
            return;
        }
        BlockPos offset = buttonPos.m_121996_((Vec3i)baseTrack);
        compoundTag.m_128385_(KEY_OFFSET, new int[]{offset.m_123341_(), offset.m_123342_(), offset.m_123343_()});
        LOGGER.info("\u504f\u79fb\u91cf\u8ba1\u7b97: {}", (Object)offset);
        int connected = 0;
        BlockPos currentTrack = baseTrack;
        while (connected < 512 && (upperTrack = this.findNextTrack(level, currentTrack)) != null) {
            BlockPos targetButton = upperTrack.m_121955_((Vec3i)offset);
            if (this.connectDevice(level, upperTrack, targetButton)) {
                ++connected;
                LOGGER.debug("\u6210\u529f\u8fde\u63a5: {} \u2192 {}", (Object)upperTrack, (Object)targetButton);
            }
            currentTrack = upperTrack;
        }
        if (context.m_43723_() != null) {
            context.m_43723_().m_5661_((Component)Component.m_237110_((String)"msg.mtryum.connection_complete", (Object[])new Object[]{connected}), false);
        }
        compoundTag.m_128473_("base_track");
        compoundTag.m_128473_(KEY_OFFSET);
    }

    private BlockPos findNextTrack(Level world, BlockPos current) {
        for (int y = 1; y <= 512; ++y) {
            BlockPos checkPos = current.m_6630_(y);
            if (!(world.m_8055_(checkPos).m_60734_() instanceof BlockLiftTrackFloor)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean connectDevice(Level world, BlockPos trackPos, BlockPos buttonPos) {
        try {
            BlockEntity be = world.m_7702_(buttonPos);
            if (be instanceof BlockLiftButtons.TileEntityLiftButtons) {
                ((BlockLiftButtons.TileEntityLiftButtons)be).registerFloor(trackPos, true);
                return true;
            }
            if (be instanceof BlockLiftPanelBase.TileEntityLiftPanel1Base) {
                ((BlockLiftPanelBase.TileEntityLiftPanel1Base)be).registerFloor(trackPos, true);
                return true;
            }
            if (be instanceof LiftArrivalLightBlock.Entity) {
                ((LiftArrivalLightBlock.Entity)be).registerFloor(trackPos, true);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("\u8fde\u63a5\u5931\u8d25: {} \u2192 {}", (Object)trackPos, (Object)buttonPos, (Object)e);
            return false;
        }
    }

    private boolean isConnectableBlock(ResourceLocation blockId) {
        String idStr = blockId.toString();
        return idStr.equals(BUTTON_ID) || idStr.equals(ID1) || idStr.equals(ID2) || idStr.equals(ID3) || idStr.equals(ID4) || idStr.equals(ID5);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.mtryum.auto_connector.line1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.mtryum.auto_connector.line2").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    protected boolean clickCondition(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        return state.m_60734_() instanceof BlockLiftTrackFloor || state.m_60734_() instanceof BlockLiftButtons || state.m_60734_() instanceof MitsubishiStyleLiftButtonsBlock || state.m_60734_() instanceof LiftArrivalLightBlock || state.m_60734_() instanceof LiftArrivalSoundPlayerBlock;
    }
}

