/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.item;

import com.yomi.mtryum.registry.MtryumItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class LiftFloorSetterItem {
    private static final String ELEVATOR_FLOOR_ID = "mtr:lift_track_floor_1";
    private static final String ELEVATOR_TRACK_ID = "mtr:lift_track_1";
    private static final String FLOOR_NBT_KEY = "floor_number";
    private static final String SOUND_PLAYER_BLOCK_ID = "mtryum:lift_arrival_sound_player";
    private static final String SOUND_INDEX_NBT_KEY = "sound_index";

    public static InteractionResult onBlockUse(Player player, Level world, InteractionHand hand, BlockHitResult hitResult) {
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_((Item)MtryumItems.LIFT_FLOOR_SETTER.get())) {
            return InteractionResult.PASS;
        }
        BlockPos startPos = hitResult.m_82425_();
        BlockState state = world.m_8055_(startPos);
        String blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
        if (blockId.equals(SOUND_PLAYER_BLOCK_ID)) {
            int selectedSound = LiftFloorSetterItem.getSoundIndexFromBlockEntity(world, startPos);
            if (selectedSound > 0) {
                LiftFloorSetterItem.processSoundPlayerChain(world, startPos, selectedSound);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!blockId.equals(ELEVATOR_FLOOR_ID)) {
            return InteractionResult.PASS;
        }
        LiftFloorSetterItem.processElevatorChain(world, startPos);
        return InteractionResult.SUCCESS;
    }

    private static int getSoundIndexFromBlockEntity(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return -1;
        }
        CompoundTag nbt = be.m_187480_();
        return nbt.m_128441_(SOUND_INDEX_NBT_KEY) ? nbt.m_128451_(SOUND_INDEX_NBT_KEY) : -1;
    }

    private static void processSoundPlayerChain(Level world, BlockPos startPos, int soundIndex) {
        int minY = startPos.m_123342_();
        int maxY = 315;
        for (int y = minY; y <= maxY; ++y) {
            BlockPos pos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
            BlockState state = world.m_8055_(pos);
            String blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
            if (!blockId.equals(SOUND_PLAYER_BLOCK_ID)) continue;
            LiftFloorSetterItem.updateSoundIndexNBT(world, pos, soundIndex);
        }
    }

    private static void updateSoundIndexNBT(Level world, BlockPos pos, int soundIndex) {
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return;
        }
        CompoundTag originalNbt = be.m_187480_();
        CompoundTag newNbt = originalNbt.m_6426_();
        newNbt.m_128405_(SOUND_INDEX_NBT_KEY, soundIndex);
        if (originalNbt.m_128451_(SOUND_INDEX_NBT_KEY) != soundIndex) {
            be.m_142466_(newNbt);
            be.m_6596_();
            world.m_7260_(pos, be.m_58900_(), be.m_58900_(), 3);
        }
    }

    private static void processElevatorChain(Level world, BlockPos startPos) {
        int currentFloor = 1;
        BlockPos currentPos = startPos;
        while (true) {
            BlockState state;
            String blockId;
            if (!(blockId = BuiltInRegistries.f_256975_.m_7981_((Object)(state = world.m_8055_(currentPos)).m_60734_()).toString()).equals(ELEVATOR_FLOOR_ID)) {
                if (!blockId.equals(ELEVATOR_TRACK_ID)) break;
                currentPos = currentPos.m_7494_();
                continue;
            }
            LiftFloorSetterItem.updateFloorNBT(world, currentPos, currentFloor++);
            currentPos = currentPos.m_7494_();
        }
    }

    private static void updateFloorNBT(Level world, BlockPos pos, int floorNumber) {
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return;
        }
        CompoundTag originalNbt = be.m_187480_();
        CompoundTag newNbt = originalNbt.m_6426_();
        String formattedFloor = String.valueOf(floorNumber);
        newNbt.m_128359_(FLOOR_NBT_KEY, formattedFloor);
        if (!formattedFloor.equals(originalNbt.m_128461_(FLOOR_NBT_KEY))) {
            be.m_142466_(newNbt);
            be.m_6596_();
            world.m_7260_(pos, be.m_58900_(), be.m_58900_(), 3);
        }
    }
}

