/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.network;

import com.yomi.mtryum.block.LiftArrivalSoundPlayerEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class SetSoundIndexPacket {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mtryum", "set_sound_index"), () -> "1", "1"::equals, "1"::equals);
    private final BlockPos pos;
    private final int soundIndex;

    public SetSoundIndexPacket(BlockPos pos, int soundIndex) {
        this.pos = pos;
        this.soundIndex = soundIndex;
    }

    public SetSoundIndexPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.soundIndex = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.soundIndex);
    }

    public static void register() {
        INSTANCE.registerMessage(0, SetSoundIndexPacket.class, SetSoundIndexPacket::toBytes, SetSoundIndexPacket::new, SetSoundIndexPacket::handle);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                this.handleClient();
            } else {
                this.handleServer((NetworkEvent.Context)ctx.get());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        BlockEntity entity;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null && (entity = client.f_91073_.m_7702_(this.pos)) instanceof LiftArrivalSoundPlayerEntity) {
            LiftArrivalSoundPlayerEntity tile = (LiftArrivalSoundPlayerEntity)entity;
            tile.setSoundIndex(this.soundIndex);
        }
    }

    private void handleServer(NetworkEvent.Context context) {
        BlockEntity entity;
        if (context.getSender() != null && context.getSender().m_9236_().m_46805_(this.pos) && (entity = context.getSender().m_9236_().m_7702_(this.pos)) instanceof LiftArrivalSoundPlayerEntity) {
            ((LiftArrivalSoundPlayerEntity)entity).setSoundIndexViaCommand(this.soundIndex);
        }
    }

    public static void send(BlockPos pos, int soundIndex) {
        INSTANCE.sendToServer((Object)new SetSoundIndexPacket(pos, soundIndex));
    }
}

