/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yomi.mtryum.block.LiftFloorMonitorBlock;
import com.yomi.mtryum.block.LiftFloorMonitorEntity;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.ClientData;
import mtr.data.Lift;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class LiftFloorMonitorRenderer
implements BlockEntityRenderer<LiftFloorMonitorEntity> {
    private static final float TEXT_OFFSET = 0.00625f;
    private static final float TEXT_SCALE = 0.015f;
    private static final float ARROW_SIZE = 0.25f;
    private static final float ARROW_OFFSET = 0.03f;
    private static final int FRAME_COUNT = 10;
    private static final long FRAME_DURATION = 100L;

    public void render(LiftFloorMonitorEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource buffer, int light, int combinedOverlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        int color = entity.getTextColor();
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        String floorNumber = "--";
        for (Lift lift : ClientData.LIFTS) {
            BlockPos currentFloor;
            BlockEntity blockEntity;
            if (!lift.hasFloor(trackPosition) || !((blockEntity = world.m_7702_(currentFloor = lift.getCurrentFloorBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) continue;
            floorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            liftDirection = lift.getLiftDirection();
            entity.updateLiftDirection(liftDirection);
            break;
        }
        if (floorNumber.isEmpty()) {
            return;
        }
        matrices.m_85836_();
        this.setupTransform(matrices, (Direction)entity.m_58900_().m_61143_((Property)LiftFloorMonitorBlock.FACING));
        if (entity.isLocked()) {
            this.renderText(matrices, buffer, "STOP", color);
        } else if (entity.getArrowStyle() == 1) {
            switch (liftDirection) {
                case UP: {
                    displayText = floorNumber + "\u2b06";
                    break;
                }
                case DOWN: {
                    displayText = floorNumber + "\u2b07";
                    break;
                }
                default: {
                    displayText = floorNumber + " ";
                }
            }
            this.renderText(matrices, buffer, displayText, color);
        } else {
            switch (liftDirection) {
                case UP: {
                    displayText = floorNumber + "\u25b2";
                    break;
                }
                case DOWN: {
                    displayText = floorNumber + "\u25bc";
                    break;
                }
                default: {
                    displayText = floorNumber + " ";
                }
            }
            this.renderText(matrices, buffer, displayText, color);
        }
        matrices.m_85849_();
    }

    private void setupTransform(PoseStack matrices, Direction facing) {
        switch (facing) {
            case NORTH: {
                matrices.m_85837_(0.47, 0.69, (double)0.00625f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                matrices.m_85837_(0.47, 0.69, (double)0.99375f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                matrices.m_85837_((double)0.99375f, 0.69, 0.47);
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                matrices.m_85837_((double)0.00625f, 0.69, 0.47);
                matrices.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            }
        }
        matrices.m_85841_(0.015f, 0.015f, 0.015f);
        matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
    }

    private void renderText(PoseStack matrices, MultiBufferSource buffer, String text, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(text);
        matrices.m_252880_((float)(-textWidth) / 2.0f, 0.0f, 0.0f);
        font.m_271703_(text, 0.0f, 0.0f, color, false, matrices.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

