/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yomi.mtryum.block.MLFMBlock;
import com.yomi.mtryum.block.MLFMEntity;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.ClientData;
import mtr.data.Lift;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class MLFMRender
implements BlockEntityRenderer<MLFMEntity> {
    private static final float TEXT_OFFSET = 0.00625f;
    private static final float TEXT_SCALE = 0.015f;

    public void render(MLFMEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource buffer, int light, int combinedOverlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        String floorNumber = "--";
        for (Lift lift : ClientData.LIFTS) {
            BlockPos currentFloor;
            BlockEntity blockEntity;
            if (!lift.hasFloor(trackPosition) || !((blockEntity = world.m_7702_(currentFloor = lift.getCurrentFloorBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) continue;
            floorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            liftDirection = lift.getLiftDirection();
            entity.updateLiftDirection(liftDirection);
            break;
        }
        if (floorNumber.isEmpty()) {
            return;
        }
        matrices.m_85836_();
        this.setupTransform(matrices, (Direction)entity.m_58900_().m_61143_((Property)MLFMBlock.FACING));
        if (entity.isLocked()) {
            this.renderText(matrices, buffer, "STOP " + floorNumber);
        } else {
            this.renderText(matrices, buffer, switch (liftDirection) {
                case Lift.LiftDirection.UP -> "\u2191 " + floorNumber;
                case Lift.LiftDirection.DOWN -> "\u2193 " + floorNumber;
                default -> "  " + floorNumber;
            });
        }
        matrices.m_85849_();
    }

    private void setupTransform(PoseStack matrices, Direction facing) {
        switch (facing) {
            case NORTH: {
                matrices.m_85837_(0.47, 0.675, (double)0.00625f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                matrices.m_85837_(0.53, 0.675, (double)0.99375f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                matrices.m_85837_((double)0.99375f, 0.675, 0.47);
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                matrices.m_85837_((double)0.00625f, 0.675, 0.53);
                matrices.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            }
        }
        matrices.m_85841_(0.015f, 0.015f, 0.015f);
        matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
    }

    private void renderText(PoseStack matrices, MultiBufferSource buffer, String text) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(text);
        matrices.m_252880_((float)(-textWidth) / 2.0f, 0.0f, 0.0f);
        font.m_271703_(text, 0.0f, 0.0f, 16747520, false, matrices.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

