/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yomi.mtryum.block.MitsubishiStyleLiftButtonsBlock;
import com.yomi.mtryum.block.MitsubishiStyleLiftButtonsBlockEntity;
import com.yomi.mtryum.registry.MtryumFonts;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.ClientData;
import mtr.data.Lift;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MitsubishiStyleLiftButtonsRenderer
implements BlockEntityRenderer<MitsubishiStyleLiftButtonsBlockEntity> {
    private static final ResourceLocation UP_NORMAL = new ResourceLocation("mtryum", "textures/block/lift_button_up_normal.png");
    private static final ResourceLocation UP_PRESSED = new ResourceLocation("mtryum", "textures/block/lift_button_up_pressed.png");
    private static final ResourceLocation DOWN_NORMAL = new ResourceLocation("mtryum", "textures/block/lift_button_down_normal.png");
    private static final ResourceLocation DOWN_PRESSED = new ResourceLocation("mtryum", "textures/block/lift_button_down_pressed.png");
    private static final ResourceLocation ARROW_UP = new ResourceLocation("mtryum", "textures/block/lift_arrow_up.png");
    private static final ResourceLocation ARROW_DOWN = new ResourceLocation("mtryum", "textures/block/lift_arrow_down.png");
    private static final float DEPTH_OFFSET = 0.002f;
    private final Font font;

    public MitsubishiStyleLiftButtonsRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.m_173586_();
    }

    public void render(MitsubishiStyleLiftButtonsBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockPos currentFloor;
        if (entity == null || entity.m_58904_() == null) {
            return;
        }
        boolean upPressed = entity.isUpButtonPressed();
        boolean downPressed = entity.isDownButtonPressed();
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos trackPosition = entity.getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        Lift.LiftDirection liftDirection = Lift.LiftDirection.NONE;
        boolean isTopFloor = false;
        boolean isBottomFloor = false;
        int currentFloorY = trackPosition.m_123342_();
        String floorNumber = "??";
        for (Lift lift : ClientData.LIFTS) {
            BlockEntity blockEntity;
            if (!lift.hasFloor(trackPosition) || !((blockEntity = world.m_7702_(currentFloor = lift.getCurrentFloorBlockPos())) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) continue;
            floorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            liftDirection = lift.getLiftDirection();
            entity.updateLiftDirection(liftDirection);
            boolean[] hasButton = new boolean[2];
            lift.hasUpDownButtonForFloor(currentFloorY, hasButton);
            isTopFloor = !hasButton[0];
            isBottomFloor = !hasButton[1];
            break;
        }
        if (floorNumber.isEmpty()) {
            return;
        }
        for (Lift lift : ClientData.LIFTS) {
            if (!lift.hasFloor(trackPosition) || (currentFloor = lift.getCurrentFloorBlockPos()) == null || !currentFloor.equals((Object)trackPosition)) continue;
            entity.liftArrived();
        }
        ResourceLocation upTexture = upPressed ? UP_PRESSED : UP_NORMAL;
        ResourceLocation downTexture = downPressed ? DOWN_PRESSED : DOWN_NORMAL;
        BlockState state = entity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)MitsubishiStyleLiftButtonsBlock.FACING);
        matrices.m_85836_();
        switch (facing) {
            case SOUTH: {
                matrices.m_85837_(0.0, -0.135, 0.99);
                break;
            }
            case EAST: {
                matrices.m_85837_(0.99, -0.135, 1.0);
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                matrices.m_85837_(1.0, -0.135, 0.01);
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                matrices.m_85837_(0.01, -0.135, 0.0);
                matrices.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            }
        }
        this.renderAllElements(matrices, vertexConsumers, light, overlay, floorNumber, liftDirection, upTexture, downTexture, facing, isTopFloor, isBottomFloor);
        matrices.m_85849_();
    }

    private void renderAllElements(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, String floorNumber, Lift.LiftDirection liftDirection, ResourceLocation upTexture, ResourceLocation downTexture, Direction facing, boolean isTopFloor, boolean isBottomFloor) {
        float BUTTON_Y_UP = 0.48f;
        float BUTTON_Y_DOWN = 0.35f;
        float ARROW_Y = 0.65f;
        float buttonSize = 0.075f;
        this.renderFloorNumber(matrices, vertexConsumers, floorNumber, light);
        if (liftDirection != Lift.LiftDirection.NONE) {
            if (liftDirection == Lift.LiftDirection.UP) {
                this.renderArrow(matrices, vertexConsumers, "\u2191", light);
            } else {
                this.renderArrow(matrices, vertexConsumers, "\u2193", light);
            }
        }
        if (!isTopFloor && isBottomFloor) {
            this.renderQuad(matrices, vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)upTexture)), 0.3825f, 0.45749998f, facing == Direction.SOUTH || facing == Direction.WEST ? 1.0f : 0.0f, facing == Direction.SOUTH || facing == Direction.WEST ? 0.0f : 1.0f, light, overlay);
        } else if (!isTopFloor) {
            this.renderQuad(matrices, vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)upTexture)), 0.4425f, 0.5175f, facing == Direction.SOUTH || facing == Direction.WEST ? 1.0f : 0.0f, facing == Direction.SOUTH || facing == Direction.WEST ? 0.0f : 1.0f, light, overlay);
        }
        if (!isBottomFloor && isTopFloor) {
            this.renderQuad(matrices, vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)downTexture)), 0.3725f, 0.4475f, facing == Direction.SOUTH || facing == Direction.WEST ? 1.0f : 0.0f, facing == Direction.SOUTH || facing == Direction.WEST ? 0.0f : 1.0f, light, overlay);
        } else if (!isBottomFloor) {
            this.renderQuad(matrices, vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)downTexture)), 0.3125f, 0.3875f, facing == Direction.SOUTH || facing == Direction.WEST ? 1.0f : 0.0f, facing == Direction.SOUTH || facing == Direction.WEST ? 0.0f : 1.0f, light, overlay);
        }
    }

    private void renderFloorNumber(PoseStack matrices, MultiBufferSource vertexConsumers, String floor, int light) {
        matrices.m_85836_();
        matrices.m_85841_(0.011f, -0.011f, 0.011f);
        matrices.m_252880_(47.0f, -71.0f, 0.0f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Font font = Minecraft.m_91087_().f_91062_;
        if (MtryumFonts.MSF_FONT != null) {
            font = MtryumFonts.MSF_FONT;
        }
        font.m_271703_(floor, 0.0f, 0.0f, 16747520, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
        matrices.m_85849_();
    }

    private void renderArrow(PoseStack matrices, MultiBufferSource vertexConsumers, String floor, int light) {
        matrices.m_85836_();
        matrices.m_85841_(0.011f, -0.011f, 0.011f);
        matrices.m_252880_(47.0f, -83.0f, 0.0f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Font font = MtryumFonts.MSF_FONT != null ? MtryumFonts.MSF_FONT : Minecraft.m_91087_().f_91062_;
        font.m_271703_(floor, 0.0f, 0.0f, 16747520, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
        matrices.m_85849_();
    }

    private void renderQuad(PoseStack matrices, VertexConsumer vertexConsumer, float minY, float maxY, float uStart, float uEnd, int light, int overlay) {
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        Matrix3f normal = matrices.m_85850_().m_252943_();
        float normalZ = 1.0f;
        vertexConsumer.m_252986_(matrix, 0.4625f, minY, 0.002f).m_6122_(255, 255, 255, 255).m_7421_(uStart, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, normalZ).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.4625f, maxY, 0.002f).m_6122_(255, 255, 255, 255).m_7421_(uStart, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, normalZ).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.5375f, maxY, 0.002f).m_6122_(255, 255, 255, 255).m_7421_(uEnd, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, normalZ).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.5375f, minY, 0.002f).m_6122_(255, 255, 255, 255).m_7421_(uEnd, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, normalZ).m_5752_();
    }
}

