/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.mtryum.screen;

import com.yomi.mtryum.block.LiftFloorMonitorEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LiftFloorMonitorScreen
extends Screen {
    private final BlockPos pos;
    private EditBox colorInput;
    private Button style1Button;
    private Button style2Button;

    public LiftFloorMonitorScreen(BlockPos pos) {
        super((Component)Component.m_237113_((String)"\u8482\u68ee\u98ce\u683c\u7535\u68af\u697c\u5c42\u663e\u793a\u5668 \u8bbe\u7f6e"));
        this.pos = pos;
    }

    protected void m_7856_() {
        BlockEntity entity;
        super.m_7856_();
        int currentColor = 0xFFFFFF;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (entity = this.f_96541_.f_91073_.m_7702_(this.pos)) instanceof LiftFloorMonitorEntity) {
            LiftFloorMonitorEntity tile = (LiftFloorMonitorEntity)entity;
            currentColor = tile.getTextColor();
        }
        this.colorInput = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 20, 200, 20, (Component)Component.m_237113_((String)"\u989c\u8272\u4ee3\u7801"));
        this.colorInput.m_94199_(6);
        this.colorInput.m_94144_(String.format("%06X", currentColor));
        this.m_142416_((GuiEventListener)this.colorInput);
        Button confirmButton = Button.m_253074_((Component)Component.m_237113_((String)"\u786e\u8ba4"), button -> this.saveAndClose()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 80, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)confirmButton);
        this.style1Button = Button.m_253074_((Component)Component.m_237113_((String)"\u6837\u5f0f1"), button -> this.setStyle(1)).m_252987_(this.f_96543_ / 2 - 105, this.f_96544_ / 2 + 45, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.style1Button);
        this.style2Button = Button.m_253074_((Component)Component.m_237113_((String)"\u6837\u5f0f2"), button -> this.setStyle(2)).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ / 2 + 45, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.style2Button);
        this.updateButtonStyles();
    }

    private void saveAndClose() {
        try {
            BlockEntity entity;
            int newColor = Integer.parseInt(this.colorInput.m_94155_(), 16);
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (entity = this.f_96541_.f_91073_.m_7702_(this.pos)) instanceof LiftFloorMonitorEntity) {
                LiftFloorMonitorEntity tile = (LiftFloorMonitorEntity)entity;
                tile.setTextColor(newColor);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("\u65e0\u6548\u989c\u8272\u4ee3\u7801: " + this.colorInput.m_94155_());
        }
        this.m_7379_();
    }

    private void setStyle(int style) {
        BlockEntity entity;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (entity = this.f_96541_.f_91073_.m_7702_(this.pos)) instanceof LiftFloorMonitorEntity) {
            LiftFloorMonitorEntity tile = (LiftFloorMonitorEntity)entity;
            tile.setArrowStyle(style);
            this.updateButtonStyles();
        }
    }

    private void updateButtonStyles() {
        BlockEntity entity;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (entity = this.f_96541_.f_91073_.m_7702_(this.pos)) instanceof LiftFloorMonitorEntity) {
            LiftFloorMonitorEntity tile = (LiftFloorMonitorEntity)entity;
            int currentStyle = tile.getArrowStyle();
            this.style1Button.f_93623_ = currentStyle != 1;
            this.style2Button.f_93623_ = currentStyle != 2;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u5341\u516d\u8fdb\u5236\u989c\u8272\u4ee3\u7801 (\u5e38\u7528: \u767dFFFFFF, \u7ea2FF0000)", this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 40, 0xAAAAAA);
        guiGraphics.m_280488_(this.f_96547_, "\u7bad\u5934\u6837\u5f0f\uff08\u8f93\u5165\u6570\u5b57\uff09", this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 25, 0xAAAAAA);
    }
}

