/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.threetag.palladium.entity.CustomProjectile;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ArmTypeProperty;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.CompoundTagProperty;
import net.threetag.palladium.util.property.EntityTypeProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ProjectileAbility
extends Ability {
    public static final PalladiumProperty<class_1299<?>> ENTITY_TYPE = new EntityTypeProperty("entity_type").configurable("Entity type ID for the projectile entity");
    public static final PalladiumProperty<class_2487> ENTITY_DATA = new CompoundTagProperty("entity_data").configurable("Entity NBT data");
    public static final PalladiumProperty<Float> INACCURACY = new FloatProperty("inaccuracy").configurable("Determines the inaccuracy when shooting the projectile");
    public static final PalladiumProperty<Float> VELOCITY = new FloatProperty("velocity").configurable("Determines the velocity when shooting the projectile");
    public static final PalladiumProperty<Float> YAW_OFFSET = new FloatProperty("yawOffset").configurable("the value offset for the yaw from the body");
    public static final PalladiumProperty<Float> PITCH_OFFSET = new FloatProperty("pitchOffset").configurable("the value offset for the pitch from the body");
    public static final PalladiumProperty<ArmTypeProperty.ArmType> SWINGING_ARM = new ArmTypeProperty("swinging_arm").configurable("Determines which arm(s) should swing upon shooting");
    public static final PalladiumProperty<Boolean> DAMAGE_FROM_PLAYER = new BooleanProperty("damage_from_player").configurable("If this is set to true and a custom projectile is used, the damage will automatically be set the player damage value");
    public static final PalladiumProperty<Boolean> IGNORE_PLAYER_MOVEMENT = new BooleanProperty("ignore_player_movement").configurable("If this is set to true and you shoot a projectile, your player's movement will NOT be added to it. Having the player movement be added is default default vanilla behaviour");

    public ProjectileAbility() {
        this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8543));
        this.withProperty(ENTITY_TYPE, class_1299.field_6068);
        this.withProperty(ENTITY_DATA, null);
        this.withProperty(INACCURACY, Float.valueOf(0.0f));
        this.withProperty(VELOCITY, Float.valueOf(1.5f));
        this.withProperty(YAW_OFFSET, Float.valueOf(-20.0f));
        this.withProperty(PITCH_OFFSET, Float.valueOf(25.0f));
        this.withProperty(SWINGING_ARM, ArmTypeProperty.ArmType.MAIN_ARM);
        this.withProperty(DAMAGE_FROM_PLAYER, false);
        this.withProperty(IGNORE_PLAYER_MOVEMENT, false);
    }

    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (!entity.method_37908().field_9236 && enabled) {
            class_2487 compound = (class_2487)entry.getProperty(ENTITY_DATA);
            compound = compound == null ? new class_2487() : compound;
            compound.method_10582("id", class_7923.field_41177.method_10221((Object)((class_1299)entry.getProperty(ENTITY_TYPE))).toString());
            class_3218 world = (class_3218)entity.method_37908();
            class_1299.method_17842((class_2487)compound, (class_1937)world, en -> {
                if (!(en instanceof class_1676)) {
                    return null;
                }
                class_1676 projectile = (class_1676)en;
                float inaccuracy = ((Float)entry.getProperty(INACCURACY)).floatValue();
                double alt_inacc = Math.random() * 2.0 * (double)inaccuracy - (double)inaccuracy;
                float pitch = -ProjectileAbility.toRadians(Float.valueOf((float)((double)(entity.method_36455() + ((Float)entry.getProperty(PITCH_OFFSET)).floatValue()) + alt_inacc)));
                float yaw = -ProjectileAbility.toRadians(Float.valueOf((float)((double)(entity.method_36454() + ((Float)entry.getProperty(YAW_OFFSET)).floatValue()) + alt_inacc)));
                double x = entity.method_23317() + Math.cos(pitch) * Math.sin(yaw);
                double y = entity.method_23318() + (double)entity.method_5751() + Math.sin(pitch);
                double z = entity.method_23321() + Math.cos(pitch) * Math.cos(yaw);
                projectile.method_5808(x, y, z, projectile.method_36454(), projectile.method_36455());
                float velocity = ((Float)entry.getProperty(VELOCITY)).floatValue();
                projectile.method_24919((class_1297)entity, entity.method_36455(), entity.method_36454(), 0.0f, velocity, inaccuracy);
                if (((Boolean)entry.getProperty(IGNORE_PLAYER_MOVEMENT)).booleanValue()) {
                    class_1268[] vec3 = entity.method_18798();
                    projectile.method_18799(projectile.method_18798().method_1023(vec3.field_1352, entity.method_24828() ? 0.0 : vec3.field_1351, vec3.field_1350));
                }
                projectile.method_7432((class_1297)entity);
                for (class_1268 hand : ((ArmTypeProperty.ArmType)entry.getProperty(SWINGING_ARM)).getHand(entity)) {
                    entity.method_23667(hand, true);
                }
                if (((Boolean)entry.getProperty(DAMAGE_FROM_PLAYER)).booleanValue() && projectile instanceof CustomProjectile) {
                    CustomProjectile customProjectile = (CustomProjectile)projectile;
                    customProjectile.damage = (float)entity.method_26825(class_5134.field_23721);
                }
                return !world.method_18768((class_1297)projectile) ? null : projectile;
            });
        }
    }

    public static float toRadians(Float arg) {
        return (float)((double)arg.floatValue() * (Math.PI / 180));
    }

    public String getDocumentationDescription() {
        return "Allows you to shoot a projectile.";
    }
}

