(function(){
    let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');
    
    StartupEvents.registry('palladium:abilities', (event) => {

        event.create('gravestone:drain_per_tick')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))

        .addProperty('energy', 'integer', 10, 'Amount of energy to drain per tick')
        .addProperty('id', 'string', "grave.codec:tachyon_device", 'Item to look for in curios slot')
        .addProperty('curios_slot', 'string', "body", 'curios slot id')
        .addProperty('trinket_slot', 'string', "chest/cape", 'trinket slot id')


        .tick((entity, entry, holder, enabled) => {
            if (!enabled) {return}
            const energyamnt = entry.getPropertyByName('energy');
            const id = entry.getPropertyByName('id');
            const curios_slot = entry.getPropertyByName('curios_slot');
            const trinket_slot = entry.getPropertyByName('trinket_slot');
            
            const items = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? curios_slot : trinket_slot);
                
                
            for (let i = 0; i < items.length; i++) {
                let item = items[i];
                
                if (item && !item.isEmpty() && item.id === id) {
                    //Utils.server.tell(item.id)

                    let holderWrapper = EnergyHelper.getFromItemStack(item)

                    if (holderWrapper.isPresent()) {
                        let energyHolder = holderWrapper.get()

                        energyHolder.withdrawEnergy(energyamnt, false);
                    }

                }
            }
        })
    });
})()