let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
//let Vec3 = Java.loadClass('net.minecraft.world.phys.Vec3');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('gravestone:knockback')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('knocks entities infront of the user back.')

        .addProperty('radius', 'integer', 10, 'Radius in which surrounding entities will be knockedback')
        .addProperty('knockback', 'float', 2.0, 'the strength of the knockback')
		.addProperty('tag_ex', 'string', 'exclusion_tag', 'Tag that exlcudes entities if desired')
        .addProperty('invert', 'boolean', false, 'Invert the knockback direction')
        .addProperty('crush', 'boolean', false, 'Crush the target if they are pressed up against a wall')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				const tag_ex = entry.getPropertyByName('tag_ex');
                let invert = entry.getPropertyByName('invert');
                let crush = entry.getPropertyByName('crush');
				let knockbackStrength = invert ? entry.getPropertyByName('knockback') / 2 *-1 : entry.getPropertyByName('knockback') / 2;
                const radius = entry.getPropertyByName('radius') * 2.0;
                let username = entity.getGameProfile().getName();
                let targets = entity.level.getEntities(entity, AABB.ofSize(entity.position(), 100, 100, 100)).toArray();
				
                let myx = entity.x
                let myy = entity.y
                let myz = entity.z

                let eye_pos = entity.getEyePosition();
                let look_angle = entity.getLookAngle();

                let distance_start = eye_pos.add(look_angle.scale(0.5));
                let distance_end = eye_pos.add(look_angle.scale(radius));

                for (let j = 0; j < targets.length; j++) {
                    let box = AABB.of(distance_start.x(), distance_start.y(), distance_start.z(), distance_end.x(), distance_end.y(), distance_end.z());
                    let entities = entity.level.getEntities(entity, box).toArray();
                    for (let i = 0; i < entities.length; i++) {
                            if (entities[i] !== entity && !containsTag(entities[i].getTags().toArray(), tag_ex) && entities[i].type !== "minecraft:item" && entities[i].type !== "minecraft:item_frame" && entities[i].type !== "minecraft:glow_item_frame" && entities[i].type !== "minecraft:armor_stand" && entities[i].type !== "palladium:suit_stand") {
                                let dx = entities[i].x - myx;
                                let dy = entities[i].y - myy;
                                let dz = entities[i].z - myz;
                                let distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            
                                if (distance > 0) {
                                    let normalizeX = dx / distance;
                                    let normalizeY = dy / distance;
                                    let normalizeZ = dz / distance;

                                    let motionX = normalizeX * knockbackStrength * 0.08;
                                    let motionY = normalizeY * knockbackStrength * 0.1;
                                    let motionZ = normalizeZ * knockbackStrength * 0.08;
                                    
                                    if (entities[i].onGround()){
                                        entities[i].addMotion(motionX, 0.0001, motionZ);
                                    }
                                    else {
                                        entities[i].addMotion(motionX, motionY, motionZ);
                                    }

                                    if (distance < 2.5 && crush) {
                                        let damage = Math.max(6, 8 - (distance / 2) * 2);
                                        entities[i].attack(damage);
                                    }

                                    if (entities[i].isPlayer()) {
                                        entities[i].connection.send(new ClientboundSetEntityMotionPacket(entities[i]));
                                    }
                                }
                            }

                        }
                    }
                }
        })
});
function containsTag(tags, tag) {
    for (let i = 0; i < tags.length; i++) {
        if(tags[i].equals(tag)) {
            return true;
        }
    }
    return false;
}