StartupEvents.registry('palladium:abilities', (event) => {
    event.create('gravestone:store_armour')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('store your armour away for when you need it most. tags: grave.armour.store stores the amour, grave.armour.add returns the armour to the player')

		.addProperty('namespace', 'string', 'minecraft', 'unique namespace for your storage location')
		.addProperty('identity', 'string', 'banana', 'unique extra name for your storage location "namespace:username_identity"')
                
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                const identity = entry.getPropertyByName('identity');
                const namespace = entry.getPropertyByName('namespace');
                let username = entity.getGameProfile().getName();
                let username_true = username.toLowerCase();

                if (!containsTag(entity, "grave.dead")){

                entity.server.runCommandSilent("execute as " + username + " at @s if entity @s[nbt={Inventory:[{Slot:103b}]}] run tag @s add grave.armour.store");
                entity.server.runCommandSilent("execute as " + username + " at @s if entity @s[nbt={Inventory:[{Slot:102b}]}] run tag @s add grave.armour.store");
                entity.server.runCommandSilent("execute as " + username + " at @s if entity @s[nbt={Inventory:[{Slot:101b}]}] run tag @s add grave.armour.store");
                entity.server.runCommandSilent("execute as " + username + " at @s if entity @s[nbt={Inventory:[{Slot:100b}]}] run tag @s add grave.armour.store");

                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run data remove storage " + namespace + ":" + username_true + "_" + identity + " ArmorItems");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run summon minecraft:armor_stand ~ ~ ~ {Marker:1b,Invisible:1b,CustomName:\'[{\"text\":\"" + username_true + "\"}]\'}");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @e[type=minecraft:armor_stand,name=" + username_true + "] armor.head from entity @s armor.head");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @e[type=minecraft:armor_stand,name=" + username_true + "] armor.chest from entity @s armor.chest");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @e[type=minecraft:armor_stand,name=" + username_true + "] armor.legs from entity @s armor.legs");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @e[type=minecraft:armor_stand,name=" + username_true + "] armor.feet from entity @s armor.feet");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run data modify storage " + namespace + ":" + username_true + "_" + identity + " ArmorItems insert 0 from entity @e[limit=1,type=minecraft:armor_stand,name=" + username_true + "] ArmorItems[]");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @s armor.head with air");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @s armor.chest with air");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @s armor.legs with air");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run item replace entity @s armor.feet with air");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run kill @e[type=minecraft:armor_stand,name=" + username_true + "]");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.store] at @s run tag @s remove grave.armour.store");

                
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run summon minecraft:armor_stand ~ ~ ~ {Marker:1b,Invisible:1b,CustomName:\'[{\"text\":\"" + username_true + "_add\"}]\'}");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run data modify entity @e[limit=1,type=minecraft:armor_stand,name=" + username_true + "_add] ArmorItems set from storage " + namespace + ":" + username_true + "_" + identity + " ArmorItems");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run item replace entity @s armor.head from entity @e[limit=1,type=minecraft:armor_stand,name=" + username_true + "_add] armor.head");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run item replace entity @s armor.chest from entity @e[limit=1,type=minecraft:armor_stand,name=" + username_true + "_add] armor.chest");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run item replace entity @s armor.legs from entity @e[limit=1,type=minecraft:armor_stand,name=" + username_true + "_add] armor.legs");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run item replace entity @s armor.feet from entity @e[limit=1,type=minecraft:armor_stand,name=" + username_true + "_add] armor.feet");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run kill @e[type=minecraft:armor_stand,name=" + username_true + "_add]");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run data remove storage " + namespace + ":" + username_true + "_" + identity + " ArmorItems");
                entity.server.runCommandSilent("execute as " + username + " as @s[tag=grave.armour.add] at @s run tag @s remove grave.armour.add");
                }

               
            }

        });
});




