/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import java.util.Comparator;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.ScoreboardUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.AttributeProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;
import net.threetag.palladium.util.property.UUIDProperty;

public class DynamicAttributeAbility
extends Ability {
    public static final PalladiumProperty<String> SCOREBOARD = new StringProperty("scoreboard").configurable("Scoreboard Name.");
    public static final PalladiumProperty<class_1320> ATTRIBUTE = new AttributeProperty("attribute").configurable("Determines which attribute should be modified. Possible attributes: " + DynamicAttributeAbility.getAttributeList());
    public static final PalladiumProperty<Double> AMOUNT = new DoubleProperty("division_amount").configurable("The amount the scoreboard value will be divided by");
    public static final PalladiumProperty<Integer> OPERATION = new IntegerProperty("operation").configurable("The operation for the giving attribute modifier (More: https://minecraft.gamepedia.com/Attribute#Operations)");
    public static final PalladiumProperty<UUID> UUID = new UUIDProperty("uuid").configurable("Sets the unique identifier for this attribute modifier. If not specified it will generate a random one");

    public DynamicAttributeAbility() {
        this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8523));
        this.withProperty(SCOREBOARD, "Score.Board");
        this.withProperty(ATTRIBUTE, class_5134.field_23724);
        this.withProperty(AMOUNT, 1.0);
        this.withProperty(OPERATION, 0);
        this.withProperty(UUID, java.util.UUID.fromString("498be4fb-af04-42f2-8948-e6ccdc0d99e1"));
    }

    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            class_1320 attribute = (class_1320)entry.getProperty(ATTRIBUTE);
            class_1324 instance = entity.method_5996(attribute);
            if (instance == null || entity.method_37908().field_9236) {
                return;
            }
            double dascore = (double)ScoreboardUtil.getScore((class_1297)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)1) / (Double)entry.getProperty(AMOUNT);
            UUID uuid = (UUID)entry.getProperty(UUID);
            class_1322 modifier = instance.method_6199(uuid);
            if (modifier != null && (modifier.method_6186() != dascore || modifier.method_6182().method_6191() != ((Integer)entry.getProperty(OPERATION)).intValue())) {
                instance.method_6200(uuid);
                modifier = null;
            }
            if (modifier == null) {
                modifier = new class_1322(uuid, entry.getConfiguration().getDisplayName().getString(), dascore, class_1322.class_1323.method_6190((int)((Integer)entry.getProperty(OPERATION))));
                instance.method_26835(modifier);
            }
        } else {
            this.lastTick(entity, entry, holder, false);
        }
    }

    public void lastTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (entity.method_5996((class_1320)entry.getProperty(ATTRIBUTE)) != null && entity.method_5996((class_1320)entry.getProperty(ATTRIBUTE)).method_6199((UUID)entry.getProperty(UUID)) != null) {
            entity.method_5996((class_1320)entry.getProperty(ATTRIBUTE)).method_6200((UUID)entry.getProperty(UUID));
        }
    }

    public static String getAttributeList() {
        return class_7923.field_41190.method_10235().stream().map(class_2960::toString).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
    }

    public String getDocumentationDescription() {
        return "Adds an attribute modifier to the entity while the ability is enabled that is entirely configurable via a scoreboard.";
    }
}

