/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.ScoreboardUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.StringProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.TagKeyListProperty;

public class ForceFieldAbility
extends Ability {
    public static final PalladiumProperty<Integer> MAXHEALTH = new IntegerProperty("max_health").configurable("sets the max health of the shield.");
    public static final PalladiumProperty<Integer> REGEN = new IntegerProperty("regen_rate").configurable("how many ticks it takes to regenerate 1 health.");
    public static final PalladiumProperty<class_2960> SOUND = new ResourceLocationProperty("sound").configurable("Sound ID that is played when a block is successful");
    public static final PalladiumProperty<String> SCOREBOARD = new StringProperty("scoreboard").configurable("optional output for shield health to a scoreboard.");
    public static final PalladiumProperty<List<class_6862<class_8110>>> DAMAGE_SOURCES = new TagKeyListProperty("damage_sources", class_7924.field_42534).configurable("Determines which damage sources have no effect on the entity based on a tag. Minecraft's builtin damage source tags: " + Arrays.toString(ForceFieldAbility.getExampleTags().stream().map(t -> t.comp_327().toString()).toArray()));
    public static final PalladiumProperty<Boolean> THORNS = new BooleanProperty("thorns").configurable("Decides of the power deals damage back to the opponent");
    public static final PalladiumProperty<Integer> HEALTH = new IntegerProperty("Health").sync(SyncType.NONE);

    public ForceFieldAbility() {
        this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8523));
        this.withProperty(SOUND, new class_2960("item.shield.block"));
        this.withProperty(MAXHEALTH, 100);
        this.withProperty(SCOREBOARD, null);
        this.withProperty(REGEN, 20);
        this.withProperty(DAMAGE_SOURCES, Arrays.asList(class_8103.field_42253, class_8103.field_42250));
        this.withProperty(THORNS, false);
    }

    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(HEALTH, (Object)100);
    }

    public void firstTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            // empty if block
        }
    }

    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (!enabled) {
            int helth = (Integer)entry.getProperty(MAXHEALTH);
            int helf = (Integer)entry.getProperty(HEALTH);
            int regen = (Integer)entry.getProperty(REGEN);
            if (helf < helth && entity.field_6012 % regen == 0) {
                entry.setUniqueProperty(HEALTH, (Object)(helf + 1));
            }
        }
        if (entry.getProperty(SCOREBOARD) != null) {
            ScoreboardUtil.setScore((class_1297)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)((Integer)entry.getProperty(HEALTH)));
        }
    }

    public static boolean isImmuneAgainst(AbilityInstance entry, class_1282 source) {
        if (!entry.isEnabled()) {
            return false;
        }
        for (class_6862 tag : (List)entry.getProperty(DAMAGE_SOURCES)) {
            if (!source.method_48789(tag)) continue;
            return true;
        }
        return false;
    }

    public String getDocumentationDescription() {
        return "makes a forcefeild around the player that deflects damage.";
    }

    public static List<class_6862<?>> getExampleTags() {
        Field[] allFields;
        ArrayList list = new ArrayList();
        for (Field field : allFields = class_8103.class.getDeclaredFields()) {
            try {
                Object object = field.get(null);
                if (!(object instanceof class_6862)) continue;
                class_6862 tag = (class_6862)object;
                list.add(tag);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }
}

