// CHARGE SCRIPT BY VENWHOVIAN
let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
//let Vec3 = Java.loadClass('net.minecraft.world.phys.Vec3');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('gravestone:charged_knockback')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('aoe knockback ability with variable knockback strength based off a score - VenWhoVian')

        .addProperty('radius', 'integer', 10, 'Radius in which surrounding entities will be damaged')
        .addProperty("score", "string", "grave.biot.shove", "what scoreboard to use for knockback strength")
        .addProperty("scoreMax", "string", "grave.biot.shoveMax", "what scoreboard to use for max possible knockback strength")
		.addProperty('tag_ex', 'string', 'exclusion_tag', 'Tag that exlcudes entities if desired')
        .addProperty('invert', 'boolean', false, 'Invert the knockback direction')

		.tick((entity, entry, holder, enabled) => {
            let score = entry.getPropertyByName("score")
            let scoreValue = palladium.scoreboard.getScore(entity, entry.getPropertyByName("score"), 10);
            let scoreMax = palladium.scoreboard.getScore(entity, entry.getPropertyByName("scoreMax"), 10);
            if (enabled && scoreValue < scoreMax)
		    palladium.scoreboard.addScore(entity, score, 2);
		})

        .lastTick((entity, entry, holder, enabled) => {
            if (enabled) {
				let score = entry.getPropertyByName("score")
				const tag_ex = entry.getPropertyByName('tag_ex');
                let invert = entry.getPropertyByName('invert');
                let knockbackStrength = invert ? (palladium.scoreboard.getScore(entity, entry.getPropertyByName("score"), 10) / 20 * -1) * 0.4 : (palladium.scoreboard.getScore(entity, entry.getPropertyByName("score"), 10) / 20) * 0.8;
                const radius = entry.getPropertyByName('radius') * 2.0;
                let targets = entity.level.getEntities(entity, AABB.ofSize(entity.position(), 100, 100, 100)).toArray();
				
                let myx = entity.x;
                let myy = entity.y; // Fixed from entity.z to entity.y
                let myz = entity.z; // Fixed from entity.z to entity.z

                for (let j = 0; j < targets.length; j++) {
                    let box = AABB.ofSize(entity.position(), radius, radius, radius);
                    let entities = entity.level.getEntities(entity, box).toArray();
                    for (let i = 0; i < entities.length; i++) {
                            if (entities[i] !== entity && !containsTag(entities[i].getTags().toArray(), tag_ex) && entities[i].type !== "minecraft:item" && entities[i].type !== "minecraft:item_frame" && entities[i].type !== "minecraft:glow_item_frame" && entities[i].type !== "minecraft:armor_stand" && entities[i].type !== "palladium:suit_stand") {
                                let dx = entities[i].x - myx;
                                let dy = entities[i].y - myy;
                                let dz = entities[i].z - myz;
                                let distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            
                                if (distance > 0) {
                                    let normalizeX = dx / distance;
                                    let normalizeY = dy / distance;
                                    let normalizeZ = dz / distance;
            
                                    let motionX = normalizeX * knockbackStrength * 0.1;
                                    let motionY = normalizeY * knockbackStrength * 0.1;
                                    let motionZ = normalizeZ * knockbackStrength * 0.1; 
            
                                    entities[i].addMotion(motionX, motionY, motionZ);

                                    if (entities[i].isPlayer()) {
                                        entities[i].connection.send(new ClientboundSetEntityMotionPacket(entities[i]));
                                    }
                                }
                            }

                        }
                    }
                    palladium.scoreboard.setScore(entity, score, 0);
                }
                
        })
});
