StartupEvents.registry('palladium:abilities', (event) => {

    event.create('gravestone:set_palladium_property_by_score')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('sets a palladium properly based on a scoreboard')

		.addProperty('palladium_property', 'string', 'graveomnicycle', 'palladium property being altered')
		.addProperty('scoreboard', 'string', 'grave.omni.setslot', 'scoreboard altering the palladium property')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				const property = entry.getPropertyByName('palladium_property');
				const scoreyworey = entry.getPropertyByName('scoreboard');
                let username = entity.getGameProfile().getName();
                let username_true = username.toLowerCase();
                let scoreboard = Utils.server.scoreboard;
                let scoreboard_obj = scoreboard.getObjective(entry.getPropertyByName("scoreboard"));
                let score = scoreboard.getOrCreatePlayerScore(username, scoreboard_obj);
                let value = score.getScore();


                palladium.setProperty(entity, property, value);
				entity.server.runCommandSilent("execute as " + username + " at @s run scoreboard players set @s "+ scoreyworey +" 0")
				
                
            }
        })
});
