/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import team.lodestar.lodestone.handlers.ScreenshakeHandler;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.screenshake.PositionedScreenshakeInstance;
import team.lodestar.lodestone.systems.screenshake.ScreenshakeInstance;

public class ScreenshakeAbility
extends Ability {
    public static final PalladiumProperty<Integer> INTENSITY = new IntegerProperty("intensity").configurable("sets the intensity of the screenshake.");
    public static final PalladiumProperty<Integer> DURATION = new IntegerProperty("duration").configurable("sets the duration of the screenshake from the first tick of the ability (in ticks).");
    public static final PalladiumProperty<Float> DISTANCE = new FloatProperty("distance").configurable("sets the distance people are effected by screenshake.");

    public ScreenshakeAbility() {
        this.withProperty(ICON, new ItemIcon((class_1935)class_1802.field_8523));
        this.withProperty(INTENSITY, 1);
        this.withProperty(DURATION, 10);
        this.withProperty(DISTANCE, Float.valueOf(26.0f));
    }

    public void firstTick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            // empty if block
        }
    }

    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity.method_37908().field_9236) {
            class_243 pos = entity.method_19538();
            ScreenshakeHandler.addScreenshake((ScreenshakeInstance)new PositionedScreenshakeInstance(((Integer)entry.getProperty(DURATION)).intValue(), pos, 0.0f, ((Float)entry.getProperty(DISTANCE)).floatValue(), Easing.SINE_IN_OUT).setIntensity((float)((Integer)entry.getProperty(INTENSITY)).intValue()));
        }
    }

    public String getDocumentationDescription() {
        return "makes the screen shake at a varying intensity.";
    }
}

