/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore;

import com.google.common.base.Suppliers;
import com.gravestone.gravecore.GraveCoreExpectPlatform;
import com.gravestone.gravecore.ability.CoreAbilities;
import com.gravestone.gravecore.ability.CoreAbilityEventHandler;
import com.gravestone.gravecore.block.CoreBlocks;
import com.gravestone.gravecore.compat.AzureLib.AzureLibCompat;
import com.gravestone.gravecore.condition.CoreConditions;
import com.gravestone.gravecore.effect.CoreEffects;
import com.gravestone.gravecore.entity.CoreAttributes;
import com.gravestone.gravecore.item.CoreItems;
import com.gravestone.gravecore.painting.CorePaintings;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladiumcore.util.Platform;

public class GraveCore {
    public static final String MOD_ID = "gravecore";
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));

    public static void init() {
        if (Platform.isModLoaded((String)"azurelib")) {
            AzureLibCompat.init();
        }
        CoreAbilities.ABILITIES.register();
        CoreConditions.CONDITION_SERIALIZERS.register();
        CoreAttributes.ATTRIBUTES.register();
        CoreEffects.EFFECTS.register();
        CorePaintings.PAINTINGS.register();
        CoreBlocks.BLOCKS.register();
        CoreItems.ITEMS.register();
        CoreAbilityEventHandler.init();
        CoreAttributes.init();
        System.out.println(GraveCoreExpectPlatform.getConfigDirectory().toAbsolutePath().normalize().toString());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

