/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;

public class AOEDamageAbility
extends Ability {
    public static final PalladiumProperty<Float> DAMAGE = new FloatProperty("damage").configurable("the amount of damage delt per tick.");
    public static final PalladiumProperty<Integer> FIRETICKS = new IntegerProperty("fire_ticks").configurable("the amount of ticks targeted entities are set on fire.");
    public static final PalladiumProperty<Integer> RADIUS = new IntegerProperty("radius").configurable("the range of which enemies can be damaged.");
    public static final PalladiumProperty<ResourceLocation> DAMAGE_TYPE = new ResourceLocationProperty("damage_type").configurable("Damage type which is applied when an entity is hit. Uses normal player/mob attack if null/unchanged.");
    public static final PalladiumProperty<Boolean> CONE = new BooleanProperty("cone").configurable("only damage entities in front of you");

    public AOEDamageAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42613_));
        this.withProperty(RADIUS, 10);
        this.withProperty(DAMAGE, Float.valueOf(1.0f));
        this.withProperty(FIRETICKS, 0);
        this.withProperty(DAMAGE_TYPE, null);
        this.withProperty(CONE, false);
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            Float dmg = (Float)entry.getProperty(DAMAGE);
            Integer firetick = (Integer)entry.getProperty(FIRETICKS);
            Integer radius = (Integer)entry.getProperty(RADIUS);
            Boolean cone = (Boolean)entry.getProperty(CONE);
            Object[] targets = entity.m_9236_().m_45933_((Entity)entity, AABB.m_165882_((Vec3)entity.m_20182_(), (double)100.0, (double)100.0, (double)100.0)).toArray();
            for (int j = 0; j < targets.length; ++j) {
                AABB box = AABB.m_165882_((Vec3)entity.m_20182_(), (double)radius.intValue(), (double)radius.intValue(), (double)radius.intValue());
                Object[] entities = entity.m_9236_().m_45933_((Entity)entity, box).toArray();
                List entiddies = entity.m_9236_().m_45933_((Entity)entity, box);
                for (int i = 0; i < entities.length; ++i) {
                    if (entiddies.get(i) == entity || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.item") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.item_frame") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.glow_item_frame") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.armor_stand") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.palladium.suit_stand")) continue;
                    double dx = ((Entity)entiddies.get(i)).m_20185_() - entity.m_20185_();
                    double dy = ((Entity)entiddies.get(i)).m_20186_() - entity.m_20186_();
                    double dz = ((Entity)entiddies.get(i)).m_20189_() - entity.m_20189_();
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    String aaahhh = ((Entity)entiddies.get(i)).m_6095_().toString();
                    if (dmg.floatValue() > 0.0f) {
                        double normalizeX = dx / distance;
                        double normalizeY = dy / distance;
                        double normalizeZ = dz / distance;
                        if (cone.booleanValue()) {
                            Vec3 lookVec = entity.m_20154_().m_82541_();
                            double dotProduct = normalizeX * lookVec.f_82479_ + normalizeY * lookVec.f_82480_ + normalizeZ * lookVec.f_82481_;
                            double coneAngleDegrees = 45.0;
                            double coneAngleRadians = Math.toRadians(coneAngleDegrees);
                            if (dotProduct < Math.cos(coneAngleRadians)) continue;
                        }
                        DamageSources dmgSources = entity.m_9236_().m_269111_();
                        ResourceLocation customType = (ResourceLocation)entry.getProperty(DAMAGE_TYPE);
                        DamageSource damageSrc = dmgSources.m_268998_(customType != null ? ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)customType) : (entity instanceof Player ? DamageTypes.f_268464_ : DamageTypes.f_268566_), (Entity)entity, (Entity)entity);
                        ((Entity)entiddies.get(i)).m_6469_(damageSrc, dmg.floatValue());
                    }
                    if (firetick <= 0) continue;
                    ((Entity)entiddies.get(i)).m_20254_(firetick.intValue());
                }
            }
        }
    }

    public String getDocumentationDescription() {
        return "damages opponents within an area.";
    }
}

