/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.ScoreboardUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class AOEKnockbackAbility
extends Ability {
    public static final PalladiumProperty<Float> KNOCKBACK = new FloatProperty("knockback").configurable("the strength of the knockback.");
    public static final PalladiumProperty<Integer> RADIUS = new IntegerProperty("radius").configurable("Radius in which surrounding entities will be knocked back.");
    public static final PalladiumProperty<Boolean> INVERT = new BooleanProperty("invert").configurable("Invert the knockback direction");
    public static final PalladiumProperty<Boolean> CONE = new BooleanProperty("cone").configurable("only knockback entities in front of you");
    public static final PalladiumProperty<Boolean> CRUSH = new BooleanProperty("crush").configurable("Crush the target if they are pressed up against a wall");
    public static final PalladiumProperty<Boolean> CHARGE = new BooleanProperty("is_charged").configurable("decides if the ability uses knockback to define strength or charges the strength using scoreboards");
    public static final PalladiumProperty<String> SCOREBOARD = new StringProperty("scoreboard").configurable("Scoreboard Name.");
    public static final PalladiumProperty<String> SCOREBOARD_MIX = new StringProperty("scoreboard_max").configurable("Scoreboard Name.");

    public AOEKnockbackAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42613_));
        this.withProperty(RADIUS, 10);
        this.withProperty(KNOCKBACK, Float.valueOf(1.0f));
        this.withProperty(INVERT, false);
        this.withProperty(CONE, false);
        this.withProperty(CRUSH, false);
        this.withProperty(CHARGE, false);
        this.withProperty(SCOREBOARD, "Score.Board");
        this.withProperty(SCOREBOARD_MIX, "Score.Board.Max");
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && !((Boolean)entry.getProperty(CHARGE)).booleanValue()) {
            Boolean invert = (Boolean)entry.getProperty(INVERT);
            Boolean cone = (Boolean)entry.getProperty(CONE);
            Boolean crush = (Boolean)entry.getProperty(CRUSH);
            float knockback = invert != false ? ((Float)entry.getProperty(KNOCKBACK)).floatValue() * -1.0f : ((Float)entry.getProperty(KNOCKBACK)).floatValue();
            int radius = (Integer)entry.getProperty(RADIUS) * 2;
            Object[] targets = entity.m_9236_().m_45933_((Entity)entity, AABB.m_165882_((Vec3)entity.m_20182_(), (double)100.0, (double)100.0, (double)100.0)).toArray();
            for (int j = 0; j < targets.length; ++j) {
                AABB box = AABB.m_165882_((Vec3)entity.m_20182_(), (double)radius, (double)radius, (double)radius);
                Object[] entities = entity.m_9236_().m_45933_((Entity)entity, box).toArray();
                List entiddies = entity.m_9236_().m_45933_((Entity)entity, box);
                for (int i = 0; i < entities.length; ++i) {
                    Object e;
                    double dz;
                    double dy;
                    if (entiddies.get(i) == entity || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.item") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.item_frame") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.glow_item_frame") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.armor_stand") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.palladium.suit_stand")) continue;
                    String aaahhh = ((Entity)entiddies.get(i)).m_6095_().toString();
                    double dx = ((Entity)entiddies.get(i)).m_20185_() - entity.m_20185_();
                    double distance = Math.sqrt(dx * dx + (dy = ((Entity)entiddies.get(i)).m_20186_() - entity.m_20186_()) * dy + (dz = ((Entity)entiddies.get(i)).m_20189_() - entity.m_20189_()) * dz);
                    if (!(distance > 0.0)) continue;
                    double normalizeX = dx / distance;
                    double normalizeY = dy / distance;
                    double normalizeZ = dz / distance;
                    if (cone.booleanValue()) {
                        Vec3 lookVec = entity.m_20154_().m_82541_();
                        double dotProduct = normalizeX * lookVec.f_82479_ + normalizeY * lookVec.f_82480_ + normalizeZ * lookVec.f_82481_;
                        double coneAngleDegrees = 45.0;
                        double coneAngleRadians = Math.toRadians(coneAngleDegrees);
                        if (dotProduct < Math.cos(coneAngleRadians)) continue;
                    }
                    double motionX = normalizeX * (double)knockback * 0.08;
                    double motionY = normalizeY * (double)knockback * 0.1;
                    double motionZ = normalizeZ * (double)knockback * 0.08;
                    if (((Entity)entiddies.get(i)).m_20096_()) {
                        ((Entity)entiddies.get(i)).m_246865_(new Vec3(motionX, 0.01, motionZ));
                    } else {
                        ((Entity)entiddies.get(i)).m_246865_(new Vec3(motionX, motionY, motionZ));
                    }
                    if (distance < 2.5 && crush.booleanValue()) {
                        DamageSource damageSource;
                        double damage = Math.max(6.0, 8.0 - distance / 2.0 * 2.0);
                        Entity entity2 = (Entity)entiddies.get(i);
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            damageSource = entity.m_9236_().m_269111_().m_269075_(player);
                        } else {
                            damageSource = entity.m_269291_().m_269333_(entity);
                        }
                        entity2.m_6469_(damageSource, (float)damage);
                    }
                    if (!((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.player") || !((e = entiddies.get(i)) instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)e;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entiddies.get(i)));
                }
            }
        }
        if (enabled && ((Boolean)entry.getProperty(CHARGE)).booleanValue()) {
            double scorevalmax;
            String score = (String)entry.getProperty(SCOREBOARD);
            double scoreval = ScoreboardUtil.getScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)10);
            if (scoreval < (scorevalmax = (double)ScoreboardUtil.getScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD_MIX)), (int)10))) {
                ScoreboardUtil.addScore((Entity)entity, (String)score, (int)2);
            }
        }
    }

    public void lastTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (((Boolean)entry.getProperty(CHARGE)).booleanValue()) {
            Boolean invert = (Boolean)entry.getProperty(INVERT);
            Boolean cone = (Boolean)entry.getProperty(CONE);
            Boolean crush = (Boolean)entry.getProperty(CRUSH);
            float knockback = (float)(invert != false ? (double)ScoreboardUtil.getScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)10) / 20.0 * -1.0 * 0.4 : (double)ScoreboardUtil.getScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)10) / 20.0 * 0.8);
            int radius = (Integer)entry.getProperty(RADIUS) * 2;
            Object[] targets = entity.m_9236_().m_45933_((Entity)entity, AABB.m_165882_((Vec3)entity.m_20182_(), (double)100.0, (double)100.0, (double)100.0)).toArray();
            for (int j = 0; j < targets.length; ++j) {
                AABB box = AABB.m_165882_((Vec3)entity.m_20182_(), (double)radius, (double)radius, (double)radius);
                Object[] entities = entity.m_9236_().m_45933_((Entity)entity, box).toArray();
                List entiddies = entity.m_9236_().m_45933_((Entity)entity, box);
                for (int i = 0; i < entities.length; ++i) {
                    Object e;
                    double dz;
                    double dy;
                    double dx;
                    double distance;
                    if (entiddies.get(i) == entity || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.item") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.item_frame") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.glow_item_frame") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.armor_stand") || ((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.palladium.suit_stand")) continue;
                    String aaahhh = ((Entity)entiddies.get(i)).m_6095_().toString();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237113_((String)aaahhh), true);
                    }
                    if (!((distance = Math.sqrt((dx = ((Entity)entiddies.get(i)).m_20185_() - entity.m_20185_()) * dx + (dy = ((Entity)entiddies.get(i)).m_20186_() - entity.m_20186_()) * dy + (dz = ((Entity)entiddies.get(i)).m_20189_() - entity.m_20189_()) * dz)) > 0.0)) continue;
                    double normalizeX = dx / distance;
                    double normalizeY = dy / distance;
                    double normalizeZ = dz / distance;
                    if (cone.booleanValue()) {
                        Vec3 lookVec = entity.m_20154_().m_82541_();
                        double dotProduct = normalizeX * lookVec.f_82479_ + normalizeY * lookVec.f_82480_ + normalizeZ * lookVec.f_82481_;
                        double coneAngleDegrees = 45.0;
                        double coneAngleRadians = Math.toRadians(coneAngleDegrees);
                        if (dotProduct < Math.cos(coneAngleRadians)) continue;
                    }
                    double motionX = normalizeX * (double)knockback * 0.08;
                    double motionY = normalizeY * (double)knockback * 0.1;
                    double motionZ = normalizeZ * (double)knockback * 0.08;
                    if (((Entity)entiddies.get(i)).m_20096_()) {
                        ((Entity)entiddies.get(i)).m_246865_(new Vec3(motionX, 0.01, motionZ));
                    } else {
                        ((Entity)entiddies.get(i)).m_246865_(new Vec3(motionX, motionY, motionZ));
                    }
                    if (distance < 2.5 && crush.booleanValue()) {
                        DamageSource damageSource;
                        double damage = Math.max(6.0, 8.0 - distance / 2.0 * 2.0);
                        Entity entity2 = (Entity)entiddies.get(i);
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            damageSource = entity.m_9236_().m_269111_().m_269075_(player);
                        } else {
                            damageSource = entity.m_269291_().m_269333_(entity);
                        }
                        entity2.m_6469_(damageSource, (float)damage);
                    }
                    if (!((Entity)entiddies.get(i)).m_6095_().toString().equals("entity.minecraft.player") || !((e = entiddies.get(i)) instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)e;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entiddies.get(i)));
                }
            }
            ScoreboardUtil.setScore((Entity)entity, (String)((String)entry.getProperty(SCOREBOARD)), (int)0);
        }
    }

    public String getDocumentationDescription() {
        return "damages opponents within an area.";
    }
}

