/*
 * Decompiled with CFR 0.152.
 */
package com.gravestone.gravecore.ability;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.EntityUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.Vec3Property;

public class BonemealAbility
extends Ability {
    public static final PalladiumProperty<Float> MAX_DISTANCE = new FloatProperty("max_distance").configurable("The maximum distance you can reach to bonemeal");
    public static final PalladiumProperty<Vec3> TARGET = new Vec3Property("distance").sync(SyncType.NONE);

    public BonemealAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42499_)).withProperty(MAX_DISTANCE, (Object)Float.valueOf(30.0f));
    }

    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(TARGET, (Object)Vec3.f_82478_);
    }

    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            // empty if block
        }
    }

    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled) {
            HitResult hit = null;
            hit = BonemealAbility.updateTargetPos(entity, entry, 1.0f);
            if (hit instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockState blockState = entity.m_9236_().m_8055_(blockHitResult.m_82425_());
                if (!blockState.m_60795_() && blockState.m_60734_() instanceof BonemealableBlock) {
                    BonemealableBlock bonemealableBlock = (BonemealableBlock)blockState.m_60734_();
                    if (bonemealableBlock.m_7370_((LevelReader)entity.m_9236_(), blockHitResult.m_82425_(), blockState, entity.m_9236_().f_46443_)) {
                        if (entity.m_9236_() instanceof ServerLevel && bonemealableBlock.m_214167_(entity.m_9236_(), entity.m_9236_().f_46441_, blockHitResult.m_82425_(), blockState)) {
                            bonemealableBlock.m_214148_((ServerLevel)entity.m_9236_(), entity.m_9236_().f_46441_, blockHitResult.m_82425_(), blockState);
                        }
                    } else if (blockState.m_204336_(BlockTags.f_13104_)) {
                        bonemealableBlock.m_214148_((ServerLevel)entity.m_9236_(), entity.m_9236_().f_46441_, blockHitResult.m_82425_(), blockState);
                    }
                }
            }
        }
    }

    public static HitResult updateTargetPos(LivingEntity living, AbilityInstance entry, float partialTick) {
        Vec3 start = living.m_20299_(partialTick);
        Vec3 end = start.m_82549_(EntityUtil.getLookVector((Entity)living, (float)partialTick).m_82490_((double)((Float)entry.getProperty(MAX_DISTANCE)).floatValue()));
        HitResult endHit = EntityUtil.rayTraceWithEntities((Entity)living, (Vec3)start, (Vec3)end, (double)start.m_82554_(end), (ClipContext.Block)ClipContext.Block.OUTLINE, (ClipContext.Fluid)ClipContext.Fluid.NONE, en -> true);
        entry.setUniqueProperty(TARGET, (Object)endHit.m_82450_());
        return endHit;
    }

    public String getDocumentationDescription() {
        return "allows a targeted location to be bonemealed.";
    }
}

